"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateOptions = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const createSitemap_1 = __importDefault(require("./createSitemap"));
const pluginOptionSchema_1 = require("./pluginOptionSchema");
function pluginSitemap(_context, options) {
    return {
        name: 'docusaurus-plugin-sitemap',
        async postBuild({ siteConfig, routesPaths, outDir }) {
            // Generate sitemap.
            const generatedSitemap = createSitemap_1.default(siteConfig, routesPaths, options).toString();
            // Write sitemap file.
            const sitemapPath = path_1.default.join(outDir, 'sitemap.xml');
            try {
                await fs_extra_1.default.outputFile(sitemapPath, generatedSitemap);
            }
            catch (err) {
                throw new Error(`Sitemap error: ${err}`);
            }
        },
    };
}
exports.default = pluginSitemap;
function validateOptions({ validate, options, }) {
    const validatedOptions = validate(pluginOptionSchema_1.PluginOptionSchema, options);
    return validatedOptions;
}
exports.validateOptions = validateOptions;
