/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
export declare function generate(generatedFilesDir: string, file: string, content: any, skipCache?: boolean): Promise<void>;
export declare function objectWithKeySorted(obj: {
    [index: string]: any;
}): any;
/**
 * Convert filepath to url path.
 * Example: 'index.md' -> '/', 'foo/bar.js' -> '/foo/bar',
 */
export declare function fileToPath(file: string): string;
export declare function encodePath(userpath: string): string;
export declare function simpleHash(str: string, length: number): string;
/**
 * Given an input string, convert to kebab-case and append a hash.
 * Avoid str collision.
 */
export declare function docuHash(str: string): string;
/**
 * Convert first string character to the upper case.
 * E.g: docusaurus -> Docusaurus
 */
export declare function upperFirst(str: string): string;
/**
 * Generate unique React Component Name.
 * E.g: /foo-bar -> FooBar096
 */
export declare function genComponentName(pagePath: string): string;
/**
 * Convert Windows backslash paths to posix style paths.
 * E.g: endi\\lie -> endi/lie
 */
export declare function posixPath(str: string): string;
/**
 * Generate unique chunk name given a module path.
 */
export declare function genChunkName(modulePath: string, prefix?: string, preferredName?: string, shortId?: boolean): string;
export declare function idx(target: any, keyPaths?: string | (string | number)[]): any;
/**
 * Given a filepath and dirpath, get the first directory.
 */
export declare function getSubFolder(file: string, refDir: string): string | null;
export declare function createExcerpt(fileString: string): string | undefined;
declare type ParsedMarkdown = {
    frontMatter: {
        [key: string]: any;
    };
    content: string;
    excerpt: string | undefined;
};
export declare function parseMarkdownString(markdownString: string): ParsedMarkdown;
export declare function parseMarkdownFile(source: string): Promise<ParsedMarkdown>;
export declare function normalizeUrl(rawUrls: string[]): string;
/**
 * Alias filepath relative to site directory, very useful so that we
 * don't expose user's site structure.
 * Example: some/path/to/website/docs/foo.md -> @site/docs/foo.md
 */
export declare function aliasedSitePath(filePath: string, siteDir: string): string;
export declare function getEditUrl(fileRelativePath: string, editUrl?: string): string | undefined;
export declare function isValidPathname(str: string): boolean;
export declare function resolvePathname(to: string, from?: string): any;
export declare function addLeadingSlash(str: string): string;
export declare function addTrailingSlash(str: string): string;
export declare function removeTrailingSlash(str: string): string;
export declare function removeSuffix(str: string, suffix: string): string;
export declare function removePrefix(str: string, prefix: string): string;
export declare function getFilePathForRoutePath(routePath: string): string;
export declare function getElementsAround<T extends unknown>(array: T[], aroundIndex: number): {
    next: T | undefined;
    previous: T | undefined;
};
export {};
//# sourceMappingURL=index.d.ts.map