"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeTileData = normalizeTileData;
exports.normalizeTileHeaders = normalizeTileHeaders;

var _tiles = require("@loaders.gl/tiles");

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function getTileType(tile) {
  if (!tile.contentUrl) {
    return _tiles.TILE_TYPE.EMPTY;
  }

  var contentUrl = tile.contentUrl;
  var fileExtension = contentUrl.split('.').pop();

  switch (fileExtension) {
    case 'pnts':
      return _tiles.TILE_TYPE.POINTCLOUD;

    case 'i3dm':
    case 'b3dm':
      return _tiles.TILE_TYPE.SCENEGRAPH;

    default:
      return fileExtension;
  }
}

function getRefine(refine) {
  switch (refine) {
    case 'REPLACE':
    case 'replace':
      return _tiles.TILE_REFINEMENT.REPLACE;

    case 'ADD':
    case 'add':
      return _tiles.TILE_REFINEMENT.ADD;

    default:
      return refine;
  }
}

function normalizeTileData(tile, options) {
  if (tile.content) {
    var contentUri = tile.content.uri || tile.content.url;
    tile.contentUrl = "".concat(options.basePath, "/").concat(contentUri);
  }

  tile.id = tile.contentUrl;
  tile.lodMetricType = _tiles.LOD_METRIC_TYPE.GEOMETRIC_ERROR;
  tile.lodMetricValue = tile.geometricError;
  tile.transformMatrix = tile.transform;
  tile.type = getTileType(tile);
  tile.refine = getRefine(tile.refine);
  return tile;
}

function normalizeTileHeaders(tileset) {
  var basePath = tileset.basePath;
  var root = normalizeTileData(tileset.root, tileset);
  var stack = [];
  stack.push(root);

  while (stack.length > 0) {
    var tile = stack.pop();
    var children = tile.children || [];

    var _iterator = _createForOfIteratorHelper(children),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var childHeader = _step.value;
        normalizeTileData(childHeader, {
          basePath: basePath
        });
        stack.push(childHeader);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }

  return root;
}
//# sourceMappingURL=parse-3d-tile-header.js.map