import { TILE3D_TYPE } from '../constants';
import { getMagicString } from './helpers/parse-utils';
import { parsePointCloud3DTile } from './parse-3d-tile-point-cloud';
import { parseBatchedModel3DTile } from './parse-3d-tile-batched-model';
import { parseInstancedModel3DTile } from './parse-3d-tile-instanced-model';
import { parseComposite3DTile } from './parse-3d-tile-composite';
export async function parse3DTile(arrayBuffer, byteOffset = 0, options, context, tile = {}) {
  options = options['3d-tiles'] || {};
  tile.byteOffset = byteOffset;
  tile.type = getMagicString(arrayBuffer, byteOffset);

  switch (tile.type) {
    case TILE3D_TYPE.COMPOSITE:
      return await parseComposite3DTile(tile, arrayBuffer, byteOffset, options, context, parse3DTile);

    case TILE3D_TYPE.BATCHED_3D_MODEL:
      return await parseBatchedModel3DTile(tile, arrayBuffer, byteOffset, options, context);

    case TILE3D_TYPE.INSTANCED_3D_MODEL:
      return await parseInstancedModel3DTile(tile, arrayBuffer, byteOffset, options, context);

    case TILE3D_TYPE.POINT_CLOUD:
      return await parsePointCloud3DTile(tile, arrayBuffer, byteOffset, options, context);

    default:
      throw new Error("3DTileLoader: unknown type ".concat(tile.type));
  }
}
//# sourceMappingURL=parse-3d-tile.js.map