import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { GL, GLType } from '@loaders.gl/math';

var Tile3DFeatureTable = function () {
  function Tile3DFeatureTable(featureTableJson, featureTableBinary) {
    _classCallCheck(this, Tile3DFeatureTable);

    this.json = featureTableJson;
    this.buffer = featureTableBinary;
    this.featuresLength = 0;
    this._cachedTypedArrays = {};
  }

  _createClass(Tile3DFeatureTable, [{
    key: "getExtension",
    value: function getExtension(extensionName) {
      return this.json.extensions && this.json.extensions[extensionName];
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return Boolean(this.json[propertyName]);
    }
  }, {
    key: "getGlobalProperty",
    value: function getGlobalProperty(propertyName) {
      var componentType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : GL.UNSIGNED_INT;
      var componentLength = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
      var jsonValue = this.json[propertyName];

      if (jsonValue && Number.isFinite(jsonValue.byteOffset)) {
        return this._getTypedArrayFromBinary(propertyName, componentType, componentLength, 1, jsonValue.byteOffset);
      }

      return jsonValue;
    }
  }, {
    key: "getPropertyArray",
    value: function getPropertyArray(propertyName, componentType, componentLength) {
      var jsonValue = this.json[propertyName];

      if (jsonValue && Number.isFinite(jsonValue.byteOffset)) {
        if ('componentType' in jsonValue) {
          componentType = GLType.fromName(jsonValue.componentType);
        }

        return this._getTypedArrayFromBinary(propertyName, componentType, componentLength, this.featuresLength, jsonValue.byteOffset);
      }

      return this._getTypedArrayFromArray(propertyName, componentType, jsonValue);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName, componentType, componentLength, featureId, result) {
      var jsonValue = this.json[propertyName];

      if (!jsonValue) {
        return jsonValue;
      }

      var typedArray = this.getPropertyArray(propertyName, componentType, componentLength);

      if (componentLength === 1) {
        return typedArray[featureId];
      }

      for (var i = 0; i < componentLength; ++i) {
        result[i] = typedArray[componentLength * featureId + i];
      }

      return result;
    }
  }, {
    key: "_getTypedArrayFromBinary",
    value: function _getTypedArrayFromBinary(propertyName, componentType, componentLength, count, byteOffset) {
      var cachedTypedArrays = this._cachedTypedArrays;
      var typedArray = cachedTypedArrays[propertyName];

      if (!typedArray) {
        typedArray = GLType.createTypedArray(componentType, this.buffer.buffer, this.buffer.byteOffset + byteOffset, count * componentLength);
        cachedTypedArrays[propertyName] = typedArray;
      }

      return typedArray;
    }
  }, {
    key: "_getTypedArrayFromArray",
    value: function _getTypedArrayFromArray(propertyName, componentType, array) {
      var cachedTypedArrays = this._cachedTypedArrays;
      var typedArray = cachedTypedArrays[propertyName];

      if (!typedArray) {
        typedArray = GLType.createTypedArray(componentType, array);
        cachedTypedArrays[propertyName] = typedArray;
      }

      return typedArray;
    }
  }]);

  return Tile3DFeatureTable;
}();

export { Tile3DFeatureTable as default };
//# sourceMappingURL=tile-3d-feature-table.js.map