import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { MAGIC_ARRAY } from '../constants';
import { encode3DTileHeader, encode3DTileByteLength } from './helpers/encode-3d-tile-header';
import { padStringToByteAlignment, copyStringToDataView, copyBinaryToDataView } from '@loaders.gl/loader-utils';
var DEFAULT_FEATURE_TABLE_JSON = {
  POINTS_LENGTH: 1,
  POSITIONS: {
    byteOffset: 0
  }
};
export function encodePointCloud3DTile(tile, dataView, byteOffset, options) {
  var _tile = tile,
      _tile$featureTableJso = _tile.featureTableJson,
      featureTableJson = _tile$featureTableJso === void 0 ? DEFAULT_FEATURE_TABLE_JSON : _tile$featureTableJso;
  var featureTableJsonString = JSON.stringify(featureTableJson);
  featureTableJsonString = padStringToByteAlignment(featureTableJsonString, 4);
  var _tile2 = tile,
      _tile2$featureTableJs = _tile2.featureTableJsonByteLength,
      featureTableJsonByteLength = _tile2$featureTableJs === void 0 ? featureTableJsonString.length : _tile2$featureTableJs;
  var featureTableBinary = new ArrayBuffer(12);
  var featureTableBinaryByteLength = featureTableBinary.byteLength;
  tile = _objectSpread({
    magic: MAGIC_ARRAY.POINT_CLOUD
  }, tile);
  var byteOffsetStart = byteOffset;
  byteOffset += encode3DTileHeader(tile, dataView, 0);

  if (dataView) {
    dataView.setUint32(byteOffset + 0, featureTableJsonByteLength, true);
    dataView.setUint32(byteOffset + 4, featureTableBinaryByteLength, true);
    dataView.setUint32(byteOffset + 8, 0, true);
    dataView.setUint32(byteOffset + 12, 0, true);
  }

  byteOffset += 16;
  byteOffset += copyStringToDataView(dataView, byteOffset, featureTableJsonString, featureTableJsonByteLength);
  byteOffset += copyBinaryToDataView(dataView, byteOffset, featureTableBinary, featureTableBinaryByteLength);
  encode3DTileByteLength(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
  return byteOffset;
}
//# sourceMappingURL=encode-3d-tile-point-cloud.js.map