"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _loaderUtils = require("@loaders.gl/loader-utils");

var _tiles = require("@loaders.gl/tiles");

var _parse3dTile = require("./lib/parsers/parse-3d-tile");

var _parse3dTileHeader = require("./lib/parsers/parse-3d-tile-header");

var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';

function getBaseUri(tileset) {
  return _loaderUtils.path.dirname(tileset.url);
}

function parseTile(_x, _x2, _x3) {
  return _parseTile.apply(this, arguments);
}

function _parseTile() {
  _parseTile = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options, context) {
    var tile, byteOffset;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            tile = {};
            tile.content = tile.content || {};
            byteOffset = 0;
            _context.next = 5;
            return (0, _parse3dTile.parse3DTile)(arrayBuffer, byteOffset, options, context, tile.content);

          case 5:
            return _context.abrupt("return", tile.content);

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parseTile.apply(this, arguments);
}

function parseTileset(_x4, _x5, _x6) {
  return _parseTileset.apply(this, arguments);
}

function _parseTileset() {
  _parseTileset = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(data, options, context) {
    var tilesetJson;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            tilesetJson = JSON.parse(new TextDecoder().decode(data));
            tilesetJson.loader = options.loader || Tiles3DLoader;
            tilesetJson.url = context.url;
            tilesetJson.basePath = getBaseUri(tilesetJson);
            tilesetJson.root = (0, _parse3dTileHeader.normalizeTileHeaders)(tilesetJson);
            tilesetJson.type = _tiles.TILESET_TYPE.TILES3D;
            tilesetJson.lodMetricType = _tiles.LOD_METRIC_TYPE.GEOMETRIC_ERROR;
            tilesetJson.lodMetricValue = tilesetJson.root.lodMetricValue;
            return _context2.abrupt("return", tilesetJson);

          case 9:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _parseTileset.apply(this, arguments);
}

function parse(_x7, _x8, _x9, _x10) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee3(data, options, context, loader) {
    var loaderOptions, isTileset;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            loaderOptions = options['3d-tiles'] || {};

            if ('isTileset' in loaderOptions) {
              isTileset = loaderOptions.isTileset;
            } else {
              isTileset = context.url && context.url.indexOf('.json') !== -1;
            }

            if (!isTileset) {
              _context3.next = 8;
              break;
            }

            _context3.next = 5;
            return parseTileset(data, options, context, loader);

          case 5:
            data = _context3.sent;
            _context3.next = 11;
            break;

          case 8:
            _context3.next = 10;
            return parseTile(data, options, context);

          case 10:
            data = _context3.sent;

          case 11:
            return _context3.abrupt("return", data);

          case 12:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _parse.apply(this, arguments);
}

var Tiles3DLoader = {
  id: '3d-tiles',
  name: '3D Tiles',
  version: VERSION,
  extensions: ['cmpt', 'pnts', 'b3dm', 'i3dm'],
  mimeTypes: ['application/octet-stream'],
  test: ['cmpt', 'pnts', 'b3dm', 'i3dm'],
  parse: parse,
  options: {
    '3d-tiles': {
      loadGLTF: true,
      decodeQuantizedPositions: false
    }
  }
};
var _default = Tiles3DLoader;
exports["default"] = _default;
//# sourceMappingURL=tiles-3d-loader.js.map