import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import Tiles3DLoader from './tiles-3d-loader';
import { getIonTilesetMetadata } from './lib/ion/ion';

async function preload(url, options = {}) {
  options = options['cesium-ion'] || {};
  const {
    accessToken
  } = options;
  let assetId = options.assetId;

  if (!Number.isFinite(assetId)) {
    const matched = url.match(/\/([0-9]+)\/tileset.json/);
    assetId = matched && matched[1];
  }

  return getIonTilesetMetadata(accessToken, assetId);
}

const CesiumIonLoader = _objectSpread(_objectSpread({}, Tiles3DLoader), {}, {
  id: 'cesium-ion',
  name: 'Cesium Ion',
  preload,
  parse: async (data, options, context, loader) => {
    options['3d-tiles'] = options['cesium-ion'];
    options.loader = CesiumIonLoader;
    return Tiles3DLoader.parse(data, options, context, loader);
  },
  options: {
    'cesium-ion': Tiles3DLoader.options['3d-tiles']
  }
});

export default CesiumIonLoader;
//# sourceMappingURL=cesium-ion-loader.js.map