import _regeneratorRuntime from "@babel/runtime/regenerator";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import Tiles3DLoader from './tiles-3d-loader';
import { getIonTilesetMetadata } from './lib/ion/ion';

function preload(_x) {
  return _preload.apply(this, arguments);
}

function _preload() {
  _preload = _asyncToGenerator(_regeneratorRuntime.mark(function _callee2(url) {
    var options,
        _options,
        accessToken,
        assetId,
        matched,
        _args2 = arguments;

    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            options = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : {};
            options = options['cesium-ion'] || {};
            _options = options, accessToken = _options.accessToken;
            assetId = options.assetId;

            if (!Number.isFinite(assetId)) {
              matched = url.match(/\/([0-9]+)\/tileset.json/);
              assetId = matched && matched[1];
            }

            return _context2.abrupt("return", getIonTilesetMetadata(accessToken, assetId));

          case 6:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _preload.apply(this, arguments);
}

var CesiumIonLoader = _objectSpread(_objectSpread({}, Tiles3DLoader), {}, {
  id: 'cesium-ion',
  name: 'Cesium Ion',
  preload: preload,
  parse: function () {
    var _parse = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(data, options, context, loader) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              options['3d-tiles'] = options['cesium-ion'];
              options.loader = CesiumIonLoader;
              return _context.abrupt("return", Tiles3DLoader.parse(data, options, context, loader));

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x2, _x3, _x4, _x5) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  options: {
    'cesium-ion': Tiles3DLoader.options['3d-tiles']
  }
});

export default CesiumIonLoader;
//# sourceMappingURL=cesium-ion-loader.js.map