import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import { GLTFLoader } from '@loaders.gl/gltf';
import { getZeroOffsetArrayBuffer } from '@loaders.gl/loader-utils';
export var GLTF_FORMAT = {
  URI: 0,
  EMBEDDED: 1
};
export function parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset) {
  tile.rotateYtoZ = true;
  var gltfByteLength = tile.byteOffset + tile.byteLength - byteOffset;

  if (gltfByteLength === 0) {
    throw new Error('glTF byte length must be greater than 0.');
  }

  tile.gltfArrayBuffer = getZeroOffsetArrayBuffer(arrayBuffer, byteOffset, gltfByteLength);
  tile.gltfByteOffset = 0;
  tile.gltfByteLength = gltfByteLength;

  if (byteOffset % 4 === 0) {} else {
    console.warn("".concat(tile.type, ": embedded glb is not aligned to a 4-byte boundary."));
  }

  return tile.byteOffset + tile.byteLength;
}
export function extractGLTF(_x, _x2, _x3, _x4) {
  return _extractGLTF.apply(this, arguments);
}

function _extractGLTF() {
  _extractGLTF = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(tile, gltfFormat, options, context) {
    var parse, fetch;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            extractGLTFBufferOrURL(tile, gltfFormat, options);

            if (!options.loadGLTF) {
              _context.next = 15;
              break;
            }

            parse = context.parse, fetch = context.fetch;

            if (!tile.gltfUrl) {
              _context.next = 8;
              break;
            }

            _context.next = 6;
            return fetch(tile.gltfUrl, options);

          case 6:
            tile.gltfArrayBuffer = _context.sent;
            tile.gltfByteOffset = 0;

          case 8:
            if (!tile.gltfArrayBuffer) {
              _context.next = 15;
              break;
            }

            _context.next = 11;
            return parse(tile.gltfArrayBuffer, GLTFLoader, options, context);

          case 11:
            tile.gltf = _context.sent;
            delete tile.gltfArrayBuffer;
            delete tile.gltfByteOffset;
            delete tile.gltfByteLength;

          case 15:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _extractGLTF.apply(this, arguments);
}

function extractGLTFBufferOrURL(tile, gltfFormat, options) {
  switch (gltfFormat) {
    case GLTF_FORMAT.URI:
      var gltfUrlBytes = new Uint8Array(tile.gltfArrayBuffer, tile.gltfByteOffset);
      var textDecoder = new TextDecoder();
      var gltfUrl = textDecoder.decode(gltfUrlBytes);
      tile.gltfUrl = gltfUrl.replace(/[\s\0]+$/, '');
      delete tile.gltfArrayBuffer;
      delete tile.gltfByteOffset;
      delete tile.gltfByteLength;
      break;

    case GLTF_FORMAT.EMBEDDED:
      break;

    default:
      throw new Error("b3dm: Illegal glTF format field");
  }
}
//# sourceMappingURL=parse-3d-tile-gltf-view.js.map