import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import { GL } from '@loaders.gl/math';
import Tile3DFeatureTable from '../classes/tile-3d-feature-table';
import { parse3DTileHeaderSync } from './helpers/parse-3d-tile-header';
import { parse3DTileTablesHeaderSync, parse3DTileTablesSync } from './helpers/parse-3d-tile-tables';
import { parse3DTileGLTFViewSync, extractGLTF, GLTF_FORMAT } from './helpers/parse-3d-tile-gltf-view';
export function parseBatchedModel3DTile(_x, _x2, _x3, _x4, _x5) {
  return _parseBatchedModel3DTile.apply(this, arguments);
}

function _parseBatchedModel3DTile() {
  _parseBatchedModel3DTile = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(tile, arrayBuffer, byteOffset, options, context) {
    var _ref, extensions;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            byteOffset = parseBatchedModel(tile, arrayBuffer, byteOffset, options, context);
            _context.next = 3;
            return extractGLTF(tile, GLTF_FORMAT.EMBEDDED, options, context);

          case 3:
            _ref = tile.gltf || {}, extensions = _ref.extensions;

            if (extensions && extensions.CESIUM_RTC) {
              tile.rtcCenter = extensions.CESIUM_RTC.center;
            }

            return _context.abrupt("return", byteOffset);

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parseBatchedModel3DTile.apply(this, arguments);
}

function parseBatchedModel(tile, arrayBuffer, byteOffset, options, context) {
  byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset, options);
  byteOffset = parse3DTileTablesHeaderSync(tile, arrayBuffer, byteOffset, options);
  byteOffset = parse3DTileTablesSync(tile, arrayBuffer, byteOffset, options);
  byteOffset = parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset, options);
  var featureTable = new Tile3DFeatureTable(tile.featureTableJson, tile.featureTableBinary);
  tile.rtcCenter = featureTable.getGlobalProperty('RTC_CENTER', GL.FLOAT, 3);
  return byteOffset;
}
//# sourceMappingURL=parse-3d-tile-batched-model.js.map