import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import { parse3DTileHeaderSync } from './helpers/parse-3d-tile-header';
export function parseComposite3DTile(_x, _x2, _x3, _x4, _x5, _x6) {
  return _parseComposite3DTile.apply(this, arguments);
}

function _parseComposite3DTile() {
  _parseComposite3DTile = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(tile, arrayBuffer, byteOffset, options, context, parse3DTile) {
    var view, subtile;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset, options);
            view = new DataView(arrayBuffer);
            tile.tilesLength = view.getUint32(byteOffset, true);
            byteOffset += 4;
            tile.tiles = [];

          case 5:
            if (!(tile.tiles.length < tile.tilesLength && tile.byteLength - byteOffset > 12)) {
              _context.next = 13;
              break;
            }

            subtile = {};
            tile.tiles.push(subtile);
            _context.next = 10;
            return parse3DTile(arrayBuffer, byteOffset, options, context, subtile);

          case 10:
            byteOffset = _context.sent;
            _context.next = 5;
            break;

          case 13:
            return _context.abrupt("return", byteOffset);

          case 14:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parseComposite3DTile.apply(this, arguments);
}
//# sourceMappingURL=parse-3d-tile-composite.js.map