import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import { TILE3D_TYPE } from '../constants';
import { getMagicString } from './helpers/parse-utils';
import { parsePointCloud3DTile } from './parse-3d-tile-point-cloud';
import { parseBatchedModel3DTile } from './parse-3d-tile-batched-model';
import { parseInstancedModel3DTile } from './parse-3d-tile-instanced-model';
import { parseComposite3DTile } from './parse-3d-tile-composite';
export function parse3DTile(_x) {
  return _parse3DTile.apply(this, arguments);
}

function _parse3DTile() {
  _parse3DTile = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(arrayBuffer) {
    var byteOffset,
        options,
        context,
        tile,
        _args = arguments;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            byteOffset = _args.length > 1 && _args[1] !== undefined ? _args[1] : 0;
            options = _args.length > 2 ? _args[2] : undefined;
            context = _args.length > 3 ? _args[3] : undefined;
            tile = _args.length > 4 && _args[4] !== undefined ? _args[4] : {};
            options = options['3d-tiles'] || {};
            tile.byteOffset = byteOffset;
            tile.type = getMagicString(arrayBuffer, byteOffset);
            _context.t0 = tile.type;
            _context.next = _context.t0 === TILE3D_TYPE.COMPOSITE ? 10 : _context.t0 === TILE3D_TYPE.BATCHED_3D_MODEL ? 13 : _context.t0 === TILE3D_TYPE.INSTANCED_3D_MODEL ? 16 : _context.t0 === TILE3D_TYPE.POINT_CLOUD ? 19 : 22;
            break;

          case 10:
            _context.next = 12;
            return parseComposite3DTile(tile, arrayBuffer, byteOffset, options, context, parse3DTile);

          case 12:
            return _context.abrupt("return", _context.sent);

          case 13:
            _context.next = 15;
            return parseBatchedModel3DTile(tile, arrayBuffer, byteOffset, options, context);

          case 15:
            return _context.abrupt("return", _context.sent);

          case 16:
            _context.next = 18;
            return parseInstancedModel3DTile(tile, arrayBuffer, byteOffset, options, context);

          case 18:
            return _context.abrupt("return", _context.sent);

          case 19:
            _context.next = 21;
            return parsePointCloud3DTile(tile, arrayBuffer, byteOffset, options, context);

          case 21:
            return _context.abrupt("return", _context.sent);

          case 22:
            throw new Error("3DTileLoader: unknown type ".concat(tile.type));

          case 23:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parse3DTile.apply(this, arguments);
}
//# sourceMappingURL=parse-3d-tile.js.map