"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DracoLoader = exports.DracoWorkerLoader = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _dracoModuleLoader = require("./lib/draco-module-loader");

var _dracoParser = _interopRequireDefault(require("./lib/draco-parser"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
var DracoWorkerLoader = {
  id: 'draco',
  name: 'Draco',
  version: VERSION,
  extensions: ['drc'],
  mimeTypes: ['application/octet-stream'],
  binary: true,
  test: 'DRACO',
  options: {
    draco: {
      decoderType: (typeof WebAssembly === "undefined" ? "undefined" : (0, _typeof2["default"])(WebAssembly)) === 'object' ? 'wasm' : 'js',
      libraryPath: "libs/",
      workerUrl: "https://unpkg.com/@loaders.gl/draco@".concat(VERSION, "/dist/draco-loader.worker.js"),
      localWorkerUrl: "modules/draco/dist/draco-loader.worker.dev.js"
    }
  }
};
exports.DracoWorkerLoader = DracoWorkerLoader;

var DracoLoader = _objectSpread(_objectSpread({}, DracoWorkerLoader), {}, {
  parse: parse
});

exports.DracoLoader = DracoLoader;

function parse(_x, _x2, _x3, _x4) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options, context, loader) {
    var _yield$loadDracoDecod, draco, dracoParser;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return (0, _dracoModuleLoader.loadDracoDecoderModule)(options);

          case 2:
            _yield$loadDracoDecod = _context.sent;
            draco = _yield$loadDracoDecod.draco;
            dracoParser = new _dracoParser["default"](draco);
            _context.prev = 5;
            return _context.abrupt("return", dracoParser.parseSync(arrayBuffer));

          case 7:
            _context.prev = 7;
            dracoParser.destroy();
            return _context.finish(7);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[5,, 7, 10]]);
  }));
  return _parse.apply(this, arguments);
}
//# sourceMappingURL=draco-loader.js.map