import { loadDracoEncoderModule } from './lib/draco-module-loader';
import DRACOBuilder from './lib/draco-builder';
export default {
  name: 'DRACO',
  extensions: ['drc'],
  encode,
  options: {
    draco: {
      pointcloud: false
    }
  }
};

async function encode(data, options) {
  const dracoOptions = options && options.draco || options || {};
  const {
    draco
  } = await loadDracoEncoderModule(options || {});
  const dracoBuilder = new DRACOBuilder(draco);

  try {
    return dracoBuilder.encodeSync(data, dracoOptions);
  } finally {
    dracoBuilder.destroy();
  }
}
//# sourceMappingURL=draco-writer.js.map