import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _typeof from "@babel/runtime/helpers/esm/typeof";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { loadDracoDecoderModule } from './lib/draco-module-loader';
import DracoParser from './lib/draco-parser';
var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
export var DracoWorkerLoader = {
  id: 'draco',
  name: 'Draco',
  version: VERSION,
  extensions: ['drc'],
  mimeTypes: ['application/octet-stream'],
  binary: true,
  test: 'DRACO',
  options: {
    draco: {
      decoderType: (typeof WebAssembly === "undefined" ? "undefined" : _typeof(WebAssembly)) === 'object' ? 'wasm' : 'js',
      libraryPath: "libs/",
      workerUrl: "https://unpkg.com/@loaders.gl/draco@".concat(VERSION, "/dist/draco-loader.worker.js"),
      localWorkerUrl: "modules/draco/dist/draco-loader.worker.dev.js"
    }
  }
};
export var DracoLoader = _objectSpread(_objectSpread({}, DracoWorkerLoader), {}, {
  parse: parse
});

function parse(_x, _x2, _x3, _x4) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(arrayBuffer, options, context, loader) {
    var _yield$loadDracoDecod, draco, dracoParser;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return loadDracoDecoderModule(options);

          case 2:
            _yield$loadDracoDecod = _context.sent;
            draco = _yield$loadDracoDecod.draco;
            dracoParser = new DracoParser(draco);
            _context.prev = 5;
            return _context.abrupt("return", dracoParser.parseSync(arrayBuffer));

          case 7:
            _context.prev = 7;
            dracoParser.destroy();
            return _context.finish(7);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[5,, 7, 10]]);
  }));
  return _parse.apply(this, arguments);
}
//# sourceMappingURL=draco-loader.js.map