import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import { loadDracoEncoderModule } from './lib/draco-module-loader';
import DRACOBuilder from './lib/draco-builder';
export default {
  name: 'DRACO',
  extensions: ['drc'],
  encode: encode,
  options: {
    draco: {
      pointcloud: false
    }
  }
};

function encode(_x, _x2) {
  return _encode.apply(this, arguments);
}

function _encode() {
  _encode = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(data, options) {
    var dracoOptions, _yield$loadDracoEncod, draco, dracoBuilder;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            dracoOptions = options && options.draco || options || {};
            _context.next = 3;
            return loadDracoEncoderModule(options || {});

          case 3:
            _yield$loadDracoEncod = _context.sent;
            draco = _yield$loadDracoEncod.draco;
            dracoBuilder = new DRACOBuilder(draco);
            _context.prev = 6;
            return _context.abrupt("return", dracoBuilder.encodeSync(data, dracoOptions));

          case 8:
            _context.prev = 8;
            dracoBuilder.destroy();
            return _context.finish(8);

          case 11:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[6,, 8, 11]]);
  }));
  return _encode.apply(this, arguments);
}
//# sourceMappingURL=draco-writer.js.map