import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var GLTF_TO_DRACO_ATTRIBUTE_NAME_MAP = {
  POSITION: 'POSITION',
  NORMAL: 'NORMAL',
  COLOR_0: 'COLOR',
  TEXCOORD_0: 'TEX_COORD'
};

function noop() {}

function dracoInt8ArrayToArrayBuffer(dracoData) {
  var byteLength = dracoData.size();
  var outputBuffer = new ArrayBuffer(byteLength);
  var outputData = new Int8Array(outputBuffer);

  for (var i = 0; i < byteLength; ++i) {
    outputData[i] = dracoData.GetValue(i);
  }

  return outputBuffer;
}

var DracoBuilder = function () {
  function DracoBuilder(draco) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, DracoBuilder);

    this.draco = draco;
    this.dracoEncoder = new this.draco.Encoder();
    this.dracoMeshBuilder = new this.draco.MeshBuilder();
    this.log = options.log || noop;
  }

  _createClass(DracoBuilder, [{
    key: "destroy",
    value: function destroy() {
      this.destroyEncodedObject(this.dracoMeshBuilder);
      this.destroyEncodedObject(this.dracoEncoder);
      this.dracoMeshBuilder = null;
      this.dracoEncoder = null;
      this.draco = null;
    }
  }, {
    key: "destroyEncodedObject",
    value: function destroyEncodedObject(object) {
      if (object) {
        this.draco.destroy(object);
      }
    }
  }, {
    key: "encodeSync",
    value: function encodeSync(mesh, options) {
      this._setOptions(options);

      return options.pointcloud ? this._encodePointCloud(mesh) : this._encodeMesh(mesh);
    }
  }, {
    key: "_getAttributesFromMesh",
    value: function _getAttributesFromMesh(mesh) {
      var attributes = _objectSpread(_objectSpread({}, mesh), mesh.attributes);

      if (mesh.indices) {
        attributes.indices = mesh.indices;
      }

      return attributes;
    }
  }, {
    key: "_encodePointCloud",
    value: function _encodePointCloud(pointcloud) {
      var attributes = this._getAttributesFromMesh(pointcloud);

      var dracoPointCloud = this._createDracoPointCloud(attributes);

      var dracoData = new this.draco.DracoInt8Array();

      try {
        var encodedLen = this.dracoEncoder.EncodePointCloudToDracoBuffer(dracoPointCloud, false, dracoData);

        if (!(encodedLen > 0)) {
          throw new Error('Draco encoding failed.');
        }

        this.log("DRACO encoded ".concat(dracoPointCloud.num_points(), " points\n        with ").concat(dracoPointCloud.num_attributes(), " attributes into ").concat(encodedLen, " bytes"));
        return dracoInt8ArrayToArrayBuffer(dracoData);
      } finally {
        this.destroyEncodedObject(dracoData);
        this.destroyEncodedObject(dracoPointCloud);
      }
    }
  }, {
    key: "_encodeMesh",
    value: function _encodeMesh(mesh) {
      var attributes = this._getAttributesFromMesh(mesh);

      var dracoMesh = this._createDracoMesh(attributes);

      var dracoData = new this.draco.DracoInt8Array();

      try {
        var encodedLen = this.dracoEncoder.EncodeMeshToDracoBuffer(dracoMesh, dracoData);

        if (encodedLen <= 0) {
          throw new Error('Draco encoding failed.');
        }

        this.log("DRACO encoded ".concat(dracoMesh.num_points(), " points\n        with ").concat(dracoMesh.num_attributes(), " attributes into ").concat(encodedLen, " bytes"));
        return dracoInt8ArrayToArrayBuffer(dracoData);
      } finally {
        this.destroyEncodedObject(dracoData);
        this.destroyEncodedObject(dracoMesh);
      }
    }
  }, {
    key: "_setOptions",
    value: function _setOptions(options) {
      if ('speed' in options) {
        var _this$dracoEncoder;

        (_this$dracoEncoder = this.dracoEncoder).SetSpeedOptions.apply(_this$dracoEncoder, _toConsumableArray(options.speed));
      }

      if ('method' in options) {
        var dracoMethod = this.draco[options.method];
        this.dracoEncoder.SetEncodingMethod(dracoMethod);
      }

      if ('quantization' in options) {
        for (var attribute in options.quantization) {
          var bits = options.quantization[attribute];
          var dracoPosition = this.draco[attribute];
          this.dracoEncoder.SetAttributeQuantization(dracoPosition, bits);
        }
      }
    }
  }, {
    key: "_createDracoMesh",
    value: function _createDracoMesh(attributes) {
      var dracoMesh = new this.draco.Mesh();

      try {
        var positions = this._getPositionAttribute(attributes);

        if (!positions) {
          throw new Error('positions');
        }

        var vertexCount = positions.length / 3;

        for (var attributeName in attributes) {
          var attribute = attributes[attributeName];
          attributeName = GLTF_TO_DRACO_ATTRIBUTE_NAME_MAP[attributeName] || attributeName;

          this._addAttributeToMesh(dracoMesh, attributeName, attribute, vertexCount);
        }
      } catch (error) {
        this.destroyEncodedObject(dracoMesh);
        throw error;
      }

      return dracoMesh;
    }
  }, {
    key: "_createDracoPointCloud",
    value: function _createDracoPointCloud(attributes) {
      var dracoPointCloud = new this.draco.PointCloud();

      try {
        var positions = this._getPositionAttribute(attributes);

        if (!positions) {
          throw new Error('positions');
        }

        var vertexCount = positions.length / 3;

        for (var attributeName in attributes) {
          var attribute = attributes[attributeName];
          attributeName = GLTF_TO_DRACO_ATTRIBUTE_NAME_MAP[attributeName] || attributeName;

          this._addAttributeToMesh(dracoPointCloud, attributeName, attribute, vertexCount);
        }
      } catch (error) {
        this.destroyEncodedObject(dracoPointCloud);
        throw error;
      }

      return dracoPointCloud;
    }
  }, {
    key: "_addAttributeToMesh",
    value: function _addAttributeToMesh(dracoMesh, attributeName, attribute, vertexCount) {
      if (!ArrayBuffer.isView(attribute)) {
        return;
      }

      var dracoAttributeType = this._getDracoAttributeType(attributeName, attribute);

      var size = attribute.length / vertexCount;

      if (dracoAttributeType === 'indices') {
        var numFaces = attribute.length / 3;
        this.log("Adding attribute ".concat(attributeName, ", size ").concat(numFaces));
        this.dracoMeshBuilder.AddFacesToMesh(dracoMesh, numFaces, attribute);
        return;
      }

      this.log("Adding attribute ".concat(attributeName, ", size ").concat(size));

      switch (attribute.constructor.name) {
        case 'Int8Array':
          this.dracoMeshBuilder.AddInt8Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Int16Array':
          this.dracoMeshBuilder.AddInt16Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Int32Array':
          this.dracoMeshBuilder.AddInt32Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Uint8Array':
        case 'Uint8ClampedArray':
          this.dracoMeshBuilder.AddUInt8Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Uint16Array':
          this.dracoMeshBuilder.AddUInt16Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Uint32Array':
          this.dracoMeshBuilder.AddUInt32Attribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
          break;

        case 'Float32Array':
        default:
          this.dracoMeshBuilder.AddFloatAttribute(dracoMesh, dracoAttributeType, vertexCount, size, attribute);
      }
    }
  }, {
    key: "_getDracoAttributeType",
    value: function _getDracoAttributeType(attributeName, attribute) {
      switch (attributeName.toLowerCase()) {
        case 'indices':
          return 'indices';

        case 'position':
        case 'positions':
        case 'vertices':
          return this.draco.POSITION;

        case 'normal':
        case 'normals':
          return this.draco.NORMAL;

        case 'color':
        case 'colors':
          return this.draco.COLOR;

        case 'texCoord':
        case 'texCoords':
          return this.draco.TEX_COORD;

        default:
          return this.draco.GENERIC;
      }
    }
  }, {
    key: "_getPositionAttribute",
    value: function _getPositionAttribute(attributes) {
      for (var attributeName in attributes) {
        var attribute = attributes[attributeName];

        var dracoType = this._getDracoAttributeType(attributeName, attribute);

        if (dracoType === this.draco.POSITION) {
          return attribute;
        }
      }

      return null;
    }
  }]);

  return DracoBuilder;
}();

export { DracoBuilder as default };
//# sourceMappingURL=draco-builder.js.map