"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _dracoModuleLoader = require("./lib/draco-module-loader");

var _dracoBuilder = _interopRequireDefault(require("./lib/draco-builder"));

var _default = {
  name: 'DRACO',
  extensions: ['drc'],
  encode: encode,
  options: {
    draco: {
      pointcloud: false
    }
  }
};
exports["default"] = _default;

function encode(_x, _x2) {
  return _encode.apply(this, arguments);
}

function _encode() {
  _encode = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(data, options) {
    var dracoOptions, _yield$loadDracoEncod, draco, dracoBuilder;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            dracoOptions = options && options.draco || options || {};
            _context.next = 3;
            return (0, _dracoModuleLoader.loadDracoEncoderModule)(options || {});

          case 3:
            _yield$loadDracoEncod = _context.sent;
            draco = _yield$loadDracoEncod.draco;
            dracoBuilder = new _dracoBuilder["default"](draco);
            _context.prev = 6;
            return _context.abrupt("return", dracoBuilder.encodeSync(data, dracoOptions));

          case 8:
            _context.prev = 8;
            dracoBuilder.destroy();
            return _context.finish(8);

          case 11:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[6,, 8, 11]]);
  }));
  return _encode.apply(this, arguments);
}
//# sourceMappingURL=draco-writer.js.map