import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { loadDracoDecoderModule } from './lib/draco-module-loader';
import DracoParser from './lib/draco-parser';
const VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
export const DracoWorkerLoader = {
  id: 'draco',
  name: 'Draco',
  version: VERSION,
  extensions: ['drc'],
  mimeTypes: ['application/octet-stream'],
  binary: true,
  test: 'DRACO',
  options: {
    draco: {
      decoderType: typeof WebAssembly === 'object' ? 'wasm' : 'js',
      libraryPath: "libs/",
      workerUrl: "https://unpkg.com/@loaders.gl/draco@".concat(VERSION, "/dist/draco-loader.worker.js"),
      localWorkerUrl: "modules/draco/dist/draco-loader.worker.dev.js"
    }
  }
};
export const DracoLoader = _objectSpread(_objectSpread({}, DracoWorkerLoader), {}, {
  parse
});

async function parse(arrayBuffer, options, context, loader) {
  const {
    draco
  } = await loadDracoDecoderModule(options);
  const dracoParser = new DracoParser(draco);

  try {
    return dracoParser.parseSync(arrayBuffer);
  } finally {
    dracoParser.destroy();
  }
}
//# sourceMappingURL=draco-loader.js.map