import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { loadLibrary, global } from '@loaders.gl/loader-utils';
let loadDecoderPromise;
let loadEncoderPromise;
export async function loadDracoDecoderModule(options) {
  const modules = options.modules || {};

  if (modules.draco3d) {
    return {
      draco: modules.draco3d.createDecoderModule()
    };
  }

  loadDecoderPromise = loadDecoderPromise || loadDracoDecoder(options);
  return await loadDecoderPromise;
}
export async function loadDracoEncoderModule(options) {
  const modules = options.modules || {};

  if (modules.draco3d) {
    return {
      draco: modules.draco3d.createEncoderModule()
    };
  }

  loadEncoderPromise = loadEncoderPromise || loadDracoEncoder(options);
  return await loadEncoderPromise;
}

async function loadDracoDecoder(options) {
  let DracoDecoderModule;
  let wasmBinary;

  switch (options.draco && options.draco.decoderType) {
    case 'js':
      DracoDecoderModule = await loadLibrary('draco_decoder.js', 'draco', options);
      break;

    case 'wasm':
    default:
      [DracoDecoderModule, wasmBinary] = await Promise.all([await loadLibrary('draco_wasm_wrapper.js', 'draco', options), await loadLibrary('draco_decoder.wasm', 'draco', options)]);
  }

  DracoDecoderModule = DracoDecoderModule || global.DracoDecoderModule;
  return await initializeDracoDecoder(DracoDecoderModule, wasmBinary);
}

function initializeDracoDecoder(DracoDecoderModule, wasmBinary) {
  const options = {};

  if (wasmBinary) {
    options.wasmBinary = wasmBinary;
  }

  return new Promise(resolve => {
    DracoDecoderModule(_objectSpread(_objectSpread({}, options), {}, {
      onModuleLoaded: draco => resolve({
        draco
      })
    }));
  });
}

async function loadDracoEncoder(options) {
  let DracoEncoderModule = await loadLibrary('draco_encoder.js', 'draco', options);
  DracoEncoderModule = DracoEncoderModule || global.DracoEncoderModule;
  return new Promise(resolve => {
    DracoEncoderModule({
      onModuleLoaded: draco => resolve({
        draco
      })
    });
  });
}
//# sourceMappingURL=draco-module-loader.js.map