"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _parseGlb = _interopRequireDefault(require("./lib/parse-glb"));

var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
var _default = {
  id: 'glb',
  name: 'GLB',
  version: VERSION,
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  binary: true,
  parse: function () {
    var _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options) {
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", parseSync(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  parseSync: parseSync,
  options: {
    glb: {
      strict: false
    }
  }
};
exports["default"] = _default;

function parseSync(arrayBuffer, options) {
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var glb = {};
  (0, _parseGlb["default"])(glb, arrayBuffer, byteOffset, options);
  return glb;
}
//# sourceMappingURL=glb-loader.js.map