"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _encodeGlb = _interopRequireDefault(require("./lib/encode-glb"));

var _default = {
  name: 'GLB',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync: encodeSync,
  binary: true,
  options: {
    glb: {}
  }
};
exports["default"] = _default;

function encodeSync(glb, options) {
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var byteLength = (0, _encodeGlb["default"])(glb, null, byteOffset, options);
  var arrayBuffer = new ArrayBuffer(byteLength);
  var dataView = new DataView(arrayBuffer);
  (0, _encodeGlb["default"])(glb, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=glb-writer.js.map