"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _encodeGltf = require("./lib/encode-gltf");

var _default = {
  name: 'glTF',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync: encodeSync,
  binary: true,
  options: {}
};
exports["default"] = _default;

function encodeSync(gltf) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var byteLength = (0, _encodeGltf.encodeGLTFSync)(gltf, null, byteOffset, options);
  var arrayBuffer = new ArrayBuffer(byteLength);
  var dataView = new DataView(arrayBuffer);
  (0, _encodeGltf.encodeGLTFSync)(gltf, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=gltf-writer.js.map