"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decode = decode;
exports.encode = encode;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _draco = require("@loaders.gl/draco");

var _loaderUtils = require("@loaders.gl/loader-utils");

var _gltfScenegraph = _interopRequireDefault(require("../gltf-scenegraph"));

var _gltfConstants = require("../gltf-constants");

var _gltfAttributeUtils = require("../gltf-utils/gltf-attribute-utils");

var _marked = _regenerator["default"].mark(meshPrimitiveIterator);

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function decode(_x, _x2, _x3) {
  return _decode.apply(this, arguments);
}

function _decode() {
  _decode = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(gltfData, options, context) {
    var scenegraph, promises, _iterator4, _step4, primitive;

    return _regenerator["default"].wrap(function _callee$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            if (options.gltf.decompressMeshes) {
              _context2.next = 2;
              break;
            }

            return _context2.abrupt("return");

          case 2:
            scenegraph = new _gltfScenegraph["default"](gltfData);
            promises = [];
            _iterator4 = _createForOfIteratorHelper(meshPrimitiveIterator(scenegraph));

            try {
              for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                primitive = _step4.value;

                if (scenegraph.getObjectExtension(primitive, _gltfConstants.KHR_DRACO_MESH_COMPRESSION)) {
                  promises.push(decompressPrimitive(primitive, scenegraph, options, context));
                }
              }
            } catch (err) {
              _iterator4.e(err);
            } finally {
              _iterator4.f();
            }

            _context2.next = 8;
            return Promise.all(promises);

          case 8:
            scenegraph.removeExtension(_gltfConstants.KHR_DRACO_MESH_COMPRESSION);

          case 9:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee);
  }));
  return _decode.apply(this, arguments);
}

function encode(gltfData) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var scenegraph = new _gltfScenegraph["default"](gltfData);

  var _iterator = _createForOfIteratorHelper(scenegraph.json.meshes || []),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var mesh = _step.value;
      compressMesh(mesh, options);
      scenegraph.addRequiredExtension(_gltfConstants.KHR_DRACO_MESH_COMPRESSION);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
}

function decompressPrimitive(_x4, _x5, _x6, _x7) {
  return _decompressPrimitive.apply(this, arguments);
}

function _decompressPrimitive() {
  _decompressPrimitive = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(primitive, scenegraph, options, context) {
    var compressedPrimitive, buffer, bufferCopy, parse, decodedData;
    return _regenerator["default"].wrap(function _callee2$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            compressedPrimitive = scenegraph.getObjectExtension(primitive, _gltfConstants.KHR_DRACO_MESH_COMPRESSION);
            buffer = scenegraph.getTypedArrayForBufferView(compressedPrimitive.bufferView);
            bufferCopy = (0, _loaderUtils.getZeroOffsetArrayBuffer)(buffer.buffer, buffer.byteOffset);
            parse = context.parse;
            _context3.next = 6;
            return parse(bufferCopy, _draco.DracoLoader, options, context);

          case 6:
            decodedData = _context3.sent;
            primitive.attributes = (0, _gltfAttributeUtils.getGLTFAccessors)(decodedData.attributes);

            if (decodedData.indices) {
              primitive.indices = (0, _gltfAttributeUtils.getGLTFAccessor)(decodedData.indices);
            }

            checkPrimitive(primitive);

          case 10:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee2);
  }));
  return _decompressPrimitive.apply(this, arguments);
}

function compressMesh(attributes, indices) {
  var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 4;
  var options = arguments.length > 3 ? arguments[3] : undefined;
  var context = arguments.length > 4 ? arguments[4] : undefined;

  if (!options.DracoWriter || !options.DracoLoader) {
    throw new Error('DracoWriter/DracoLoader not available');
  }

  var compressedData = options.DracoWriter.encodeSync({
    attributes: attributes
  });
  var parseSync = context.parseSync;
  var decodedData = parseSync({
    attributes: attributes
  });

  var fauxAccessors = options._addFauxAttributes(decodedData.attributes);

  var bufferViewIndex = options.addBufferView(compressedData);
  var glTFMesh = {
    primitives: [{
      attributes: fauxAccessors,
      mode: mode,
      extensions: (0, _defineProperty2["default"])({}, _gltfConstants.KHR_DRACO_MESH_COMPRESSION, {
        bufferView: bufferViewIndex,
        attributes: fauxAccessors
      })
    }]
  };
  return glTFMesh;
}

function checkPrimitive(primitive) {
  if (!primitive.attributes && Object.keys(primitive.attributes).length > 0) {
    throw new Error('Empty glTF primitive detected: Draco decompression failure?');
  }
}

function meshPrimitiveIterator(scenegraph) {
  var _iterator2, _step2, mesh, _iterator3, _step3, primitive;

  return _regenerator["default"].wrap(function meshPrimitiveIterator$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _iterator2 = _createForOfIteratorHelper(scenegraph.json.meshes || []);
          _context.prev = 1;

          _iterator2.s();

        case 3:
          if ((_step2 = _iterator2.n()).done) {
            _context.next = 24;
            break;
          }

          mesh = _step2.value;
          _iterator3 = _createForOfIteratorHelper(mesh.primitives);
          _context.prev = 6;

          _iterator3.s();

        case 8:
          if ((_step3 = _iterator3.n()).done) {
            _context.next = 14;
            break;
          }

          primitive = _step3.value;
          _context.next = 12;
          return primitive;

        case 12:
          _context.next = 8;
          break;

        case 14:
          _context.next = 19;
          break;

        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](6);

          _iterator3.e(_context.t0);

        case 19:
          _context.prev = 19;

          _iterator3.f();

          return _context.finish(19);

        case 22:
          _context.next = 3;
          break;

        case 24:
          _context.next = 29;
          break;

        case 26:
          _context.prev = 26;
          _context.t1 = _context["catch"](1);

          _iterator2.e(_context.t1);

        case 29:
          _context.prev = 29;

          _iterator2.f();

          return _context.finish(29);

        case 32:
        case "end":
          return _context.stop();
      }
    }
  }, _marked, null, [[1, 26, 29, 32], [6, 16, 19, 22]]);
}
//# sourceMappingURL=KHR_draco_mesh_compression.js.map