"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decode = decode;
exports.encode = encode;

var _assert = _interopRequireDefault(require("../utils/assert"));

var _gltfScenegraph = _interopRequireDefault(require("../gltf-scenegraph"));

var _gltfConstants = require("../gltf-constants");

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function decode(gltfData, options) {
  var gltfScenegraph = new _gltfScenegraph["default"](gltfData);
  var json = gltfScenegraph.json;
  var extension = gltfScenegraph.getExtension(_gltfConstants.KHR_LIGHTS_PUNCTUAL);

  if (extension) {
    gltfScenegraph.json.lights = extension.lights;
    gltfScenegraph.removeExtension(_gltfConstants.KHR_LIGHTS_PUNCTUAL);
  }

  var _iterator = _createForOfIteratorHelper(json.nodes || []),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var node = _step.value;
      var nodeExtension = gltfScenegraph.getObjectExtension(node, _gltfConstants.KHR_LIGHTS_PUNCTUAL);

      if (nodeExtension) {
        node.light = nodeExtension.light;
      }

      gltfScenegraph.removeObjectExtension(node, _gltfConstants.KHR_LIGHTS_PUNCTUAL);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
}

function encode(gltfData, options) {
  var gltfScenegraph = new _gltfScenegraph["default"](gltfData);
  var json = gltfScenegraph.json;

  if (json.lights) {
    var extension = gltfScenegraph.addExtension(_gltfConstants.KHR_LIGHTS_PUNCTUAL);
    (0, _assert["default"])(!extension.lights);
    extension.lights = json.lights;
    delete json.lights;
  }

  if (gltfScenegraph.json.lights) {
    var _iterator2 = _createForOfIteratorHelper(gltfScenegraph.json.lights),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var light = _step2.value;
        var node = light.node;
        gltfScenegraph.addObjectExtension(node, _gltfConstants.KHR_LIGHTS_PUNCTUAL, light);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    delete gltfScenegraph.json.lights;
  }
}
//# sourceMappingURL=KHR_lights_punctual.js.map