"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGLTF = isGLTF;
exports.parseGLTF = parseGLTF;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _images = require("@loaders.gl/images");

var _loaderUtils = require("@loaders.gl/loader-utils");

var _assert = _interopRequireDefault(require("./utils/assert"));

var _resolveUrl = require("./gltf-utils/resolve-url");

var _getTypedArray = require("./gltf-utils/get-typed-array");

var _gltfExtensions = require("./extensions/gltf-extensions");

var _parseGlb = _interopRequireWildcard(require("./parse-glb"));

var _postProcessGltf = _interopRequireDefault(require("./post-process-gltf"));

function isGLTF(arrayBuffer) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var dataView = new DataView(arrayBuffer);
  var byteOffset = 0;
  return (0, _parseGlb.isGLB)(dataView, byteOffset);
}

function parseGLTF(_x, _x2) {
  return _parseGLTF.apply(this, arguments);
}

function _parseGLTF() {
  _parseGLTF = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(gltf, arrayBufferOrString) {
    var byteOffset,
        options,
        context,
        promises,
        _promise,
        promise,
        _args = arguments;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            byteOffset = _args.length > 2 && _args[2] !== undefined ? _args[2] : 0;
            options = _args.length > 3 ? _args[3] : undefined;
            context = _args.length > 4 ? _args[4] : undefined;
            parseGLTFContainerSync(gltf, arrayBufferOrString, byteOffset, options);
            promises = [];

            if (options.gltf.loadImages) {
              _promise = loadImages(gltf, options, context);
              promises.push(_promise);
            }

            if (!options.gltf.loadBuffers) {
              _context.next = 9;
              break;
            }

            _context.next = 9;
            return loadBuffers(gltf, options, context);

          case 9:
            promise = (0, _gltfExtensions.decodeExtensions)(gltf, options, context);
            promises.push(promise);
            _context.next = 13;
            return Promise.all(promises);

          case 13:
            return _context.abrupt("return", options.gltf.postProcess ? (0, _postProcessGltf["default"])(gltf, options) : gltf);

          case 14:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parseGLTF.apply(this, arguments);
}

function parseGLTFContainerSync(gltf, data, byteOffset, options) {
  if (options.uri) {
    gltf.baseUri = options.uri;
  }

  if (data instanceof ArrayBuffer && !(0, _parseGlb.isGLB)(data, byteOffset, options)) {
    var textDecoder = new TextDecoder();
    data = textDecoder.decode(data);
  }

  if (typeof data === 'string') {
    gltf.json = (0, _loaderUtils.parseJSON)(data);
  } else if (data instanceof ArrayBuffer) {
    var glb = {};
    byteOffset = (0, _parseGlb["default"])(glb, data, byteOffset, options);
    (0, _assert["default"])(glb.type === 'glTF', "Invalid GLB magic string ".concat(glb.type));
    gltf._glb = glb;
    gltf.json = glb.json;
  } else {
    (0, _assert["default"])(false, "GLTF: must be ArrayBuffer or string");
  }

  var buffers = gltf.json.buffers || [];
  gltf.buffers = new Array(buffers.length).fill(null);

  if (gltf._glb && gltf._glb.header.hasBinChunk) {
    var binChunks = gltf._glb.binChunks;
    gltf.buffers[0] = {
      arrayBuffer: binChunks[0].arrayBuffer,
      byteOffset: binChunks[0].byteOffset,
      byteLength: binChunks[0].byteLength
    };
  }

  var images = gltf.json.images || [];
  gltf.images = new Array(images.length).fill({});
}

function loadBuffers(_x3, _x4, _x5) {
  return _loadBuffers.apply(this, arguments);
}

function _loadBuffers() {
  _loadBuffers = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(gltf, options, context) {
    var i, buffer, fetch, uri, response, arrayBuffer;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            i = 0;

          case 1:
            if (!(i < gltf.json.buffers.length)) {
              _context2.next = 18;
              break;
            }

            buffer = gltf.json.buffers[i];

            if (!buffer.uri) {
              _context2.next = 15;
              break;
            }

            fetch = context.fetch;
            (0, _assert["default"])(fetch);
            uri = (0, _resolveUrl.resolveUrl)(buffer.uri, options);
            _context2.next = 9;
            return fetch(uri);

          case 9:
            response = _context2.sent;
            _context2.next = 12;
            return response.arrayBuffer();

          case 12:
            arrayBuffer = _context2.sent;
            gltf.buffers[i] = {
              arrayBuffer: arrayBuffer,
              byteOffset: 0,
              byteLength: arrayBuffer.byteLength
            };
            delete buffer.uri;

          case 15:
            ++i;
            _context2.next = 1;
            break;

          case 18:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _loadBuffers.apply(this, arguments);
}

function loadImages(_x6, _x7, _x8) {
  return _loadImages.apply(this, arguments);
}

function _loadImages() {
  _loadImages = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee3(gltf, options, context) {
    var images, promises, i;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            images = gltf.json.images || [];
            promises = [];

            for (i = 0; i < images.length; ++i) {
              promises.push(loadImage(gltf, images[i], i, options, context));
            }

            _context3.next = 5;
            return Promise.all(promises);

          case 5:
            return _context3.abrupt("return", _context3.sent);

          case 6:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _loadImages.apply(this, arguments);
}

function loadImage(_x9, _x10, _x11, _x12, _x13) {
  return _loadImage.apply(this, arguments);
}

function _loadImage() {
  _loadImage = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee4(gltf, image, i, options, context) {
    var fetch, parse, arrayBuffer, uri, response, array, parsedImage;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            fetch = context.fetch, parse = context.parse;

            if (!image.uri) {
              _context4.next = 9;
              break;
            }

            uri = (0, _resolveUrl.resolveUrl)(image.uri, options);
            _context4.next = 5;
            return fetch(uri);

          case 5:
            response = _context4.sent;
            _context4.next = 8;
            return response.arrayBuffer();

          case 8:
            arrayBuffer = _context4.sent;

          case 9:
            if (Number.isFinite(image.bufferView)) {
              array = (0, _getTypedArray.getTypedArrayForBufferView)(gltf.json, gltf.buffers, image.bufferView);
              arrayBuffer = (0, _loaderUtils.getZeroOffsetArrayBuffer)(array.buffer, array.byteOffset, array.byteLength);
            }

            (0, _assert["default"])(arrayBuffer, 'glTF image has no data');
            _context4.next = 13;
            return parse(arrayBuffer, _images.ImageLoader, {}, context);

          case 13:
            parsedImage = _context4.sent;
            gltf.images[i] = parsedImage;

          case 15:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _loadImage.apply(this, arguments);
}
//# sourceMappingURL=parse-gltf.js.map