import parseGLBSync from './lib/parse-glb';
const VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
export default {
  id: 'glb',
  name: 'GLB',
  version: VERSION,
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  binary: true,
  parse: async (arrayBuffer, options) => parseSync(arrayBuffer, options),
  parseSync,
  options: {
    glb: {
      strict: false
    }
  }
};

function parseSync(arrayBuffer, options) {
  const {
    byteOffset = 0
  } = options;
  const glb = {};
  parseGLBSync(glb, arrayBuffer, byteOffset, options);
  return glb;
}
//# sourceMappingURL=glb-loader.js.map