import { encodeGLTFSync } from './lib/encode-gltf';
export default {
  name: 'glTF',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync,
  binary: true,
  options: {}
};

function encodeSync(gltf, options = {}) {
  const {
    byteOffset = 0
  } = options;
  const byteLength = encodeGLTFSync(gltf, null, byteOffset, options);
  const arrayBuffer = new ArrayBuffer(byteLength);
  const dataView = new DataView(arrayBuffer);
  encodeGLTFSync(gltf, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=gltf-writer.js.map