import GLTFScenegraph from '../gltf-scenegraph';
import { KHR_MATERIALS_UNLIT } from '../gltf-constants';
export function decode(gltfData, options) {
  const gltfScenegraph = new GLTFScenegraph(gltfData);
  const {
    json
  } = gltfScenegraph;
  gltfScenegraph.removeExtension(KHR_MATERIALS_UNLIT);

  for (const material of json.materials || []) {
    const extension = material.extensions && material.extensions.KHR_materials_unlit;

    if (extension) {
      material.unlit = true;
    }

    gltfScenegraph.removeObjectExtension(material, KHR_MATERIALS_UNLIT);
  }
}
export function encode(gltfData, options) {
  const gltfScenegraph = new GLTFScenegraph(gltfData);
  const {
    json
  } = gltfScenegraph;

  if (gltfScenegraph.materials) {
    for (const material of json.materials) {
      if (material.unlit) {
        delete material.unlit;
        gltfScenegraph.addObjectExtension(material, KHR_MATERIALS_UNLIT);
        gltfScenegraph.addExtension(KHR_MATERIALS_UNLIT);
      }
    }
  }
}
//# sourceMappingURL=KHR_materials_unlit.js.map