import { encodeGLTFSync } from './lib/encode-gltf';
export default {
  name: 'glTF',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync: encodeSync,
  binary: true,
  options: {}
};

function encodeSync(gltf) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var byteLength = encodeGLTFSync(gltf, null, byteOffset, options);
  var arrayBuffer = new ArrayBuffer(byteLength);
  var dataView = new DataView(arrayBuffer);
  encodeGLTFSync(gltf, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=gltf-writer.js.map