import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import { getBinaryImageMIMEType, getBinaryImageSize } from '@loaders.gl/images';
import assert from '../utils/assert';
import { UBER_POINT_CLOUD_EXTENSION } from '../gltf-constants';
import GLBBuilder from './glb-builder';

function packBinaryJson(data, builder, packOptions) {
  assert(!packOptions.packTypedArrays);
  return data;
}

var GLTFBuilder = function (_GLBBuilder) {
  _inherits(GLTFBuilder, _GLBBuilder);

  var _super = _createSuper(GLTFBuilder);

  function GLTFBuilder() {
    var _this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, GLTFBuilder);

    _this = _super.call(this, options);
    _this.DracoWriter = options.DracoWriter;
    _this.DracoLoader = options.DracoLoader;
    return _this;
  }

  _createClass(GLTFBuilder, [{
    key: "addApplicationData",
    value: function addApplicationData(key, data) {
      var packOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var jsonData = packOptions.packTypedArrays ? packBinaryJson(data, this, packOptions) : data;
      this.json[key] = jsonData;
      return this;
    }
  }, {
    key: "addExtraData",
    value: function addExtraData(key, data) {
      var packOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var packedJson = packOptions.packedTypedArrays ? packBinaryJson(data, this, packOptions) : data;
      this.json.extras = this.json.extras || {};
      this.json.extras[key] = packedJson;
      return this;
    }
  }, {
    key: "addExtension",
    value: function addExtension(extensionName, data) {
      var packOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      assert(data);
      var packedJson = packOptions.packTypedArrays ? packBinaryJson(data, this, packOptions) : data;
      this.json.extensions = this.json.extensions || {};
      this.json.extensions[extensionName] = packedJson;
      this.registerUsedExtension(extensionName);
      return this;
    }
  }, {
    key: "addRequiredExtension",
    value: function addRequiredExtension(extensionName, data) {
      var packOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      assert(data);
      var packedJson = packOptions.packTypedArrays ? packBinaryJson(data, this, packOptions) : data;
      this.addExtension(extensionName, packedJson);
      this.registerRequiredExtension(extensionName);
      return this;
    }
  }, {
    key: "registerUsedExtension",
    value: function registerUsedExtension(extensionName) {
      this.json.extensionsUsed = this.json.extensionsUsed || [];

      if (!this.json.extensionsUsed.find(function (ext) {
        return ext === extensionName;
      })) {
        this.json.extensionsUsed.push(extensionName);
      }
    }
  }, {
    key: "registerRequiredExtension",
    value: function registerRequiredExtension(extensionName) {
      this.registerUsedExtension(extensionName);
      this.json.extensionsRequired = this.json.extensionsRequired || [];

      if (!this.json.extensionsRequired.find(function (ext) {
        return ext === extensionName;
      })) {
        this.json.extensionsRequired.push(extensionName);
      }
    }
  }, {
    key: "addMesh",
    value: function addMesh(attributes, indices) {
      var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 4;
      assert(false);
      return -1;
    }
  }, {
    key: "addPointCloud",
    value: function addPointCloud(attributes) {
      assert(false);
      return -1;
    }
  }, {
    key: "addCompressedMesh",
    value: function addCompressedMesh(attributes, indices) {
      var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 4;
      assert(false);
      return -1;
    }
  }, {
    key: "addCompressedPointCloud",
    value: function addCompressedPointCloud(attributes) {
      if (!this.DracoWriter || !this.DracoLoader) {
        throw new Error('DracoWriter/DracoLoader not available');
      }

      attributes.mode = 0;
      var compressedData = this.DracoWriter.encodeSync(attributes, {
        draco: {
          pointcloud: true
        }
      });
      var bufferViewIndex = this.addBufferView(compressedData);
      var glTFMesh = {
        primitives: [{
          attributes: {},
          mode: 0,
          extensions: _defineProperty({}, UBER_POINT_CLOUD_EXTENSION, {
            bufferView: bufferViewIndex
          })
        }]
      };
      this.registerRequiredExtension(UBER_POINT_CLOUD_EXTENSION);
      this.json.meshes = this.json.meshes || [];
      this.json.meshes.push(glTFMesh);
      return this.json.meshes.length - 1;
    }
  }, {
    key: "addImage",
    value: function addImage(imageData) {
      var bufferViewIndex = this.addBufferView(imageData);
      var mimeType = getBinaryImageMIMEType(imageData) || {};

      if (mimeType) {
        var _ref = getBinaryImageSize(imageData, mimeType) || {},
            width = _ref.width,
            height = _ref.height;

        this.json.images.push({
          bufferView: bufferViewIndex,
          mimeType: mimeType,
          width: width,
          height: height
        });
      } else {
        this.json.images.push({
          bufferView: bufferViewIndex
        });
      }

      return this.json.images.length - 1;
    }
  }]);

  return GLTFBuilder;
}(GLBBuilder);

export { GLTFBuilder as default };
//# sourceMappingURL=gltf-builder.js.map