import _typeof from "@babel/runtime/helpers/esm/typeof";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

import GLTFScenegraph from '../gltf-scenegraph';
import { KHR_TECHNIQUES_WEBGL } from '../gltf-constants';
export function decode(gltfData, options) {
  var gltfScenegraph = new GLTFScenegraph(gltfData);
  var json = gltfScenegraph.json;
  var extension = gltfScenegraph.getExtension(KHR_TECHNIQUES_WEBGL);

  if (extension) {
    var techniques = resolveTechniques(extension, gltfScenegraph);

    var _iterator = _createForOfIteratorHelper(json.materials || []),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var material = _step.value;
        var materialExtension = gltfScenegraph.getObjectExtension(material, KHR_TECHNIQUES_WEBGL);

        if (materialExtension) {
          material.technique = Object.assign({}, materialExtension, techniques[materialExtension.technique]);
          material.technique.values = resolveValues(material.technique, gltfScenegraph);
        }

        gltfScenegraph.removeObjectExtension(material, KHR_TECHNIQUES_WEBGL);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    gltfScenegraph.removeExtension(KHR_TECHNIQUES_WEBGL);
  }
}
export function encode(gltfData, options) {}

function resolveTechniques(_ref, gltfScenegraph) {
  var _ref$programs = _ref.programs,
      programs = _ref$programs === void 0 ? [] : _ref$programs,
      _ref$shaders = _ref.shaders,
      shaders = _ref$shaders === void 0 ? [] : _ref$shaders,
      _ref$techniques = _ref.techniques,
      techniques = _ref$techniques === void 0 ? [] : _ref$techniques;
  var textDecoder = new TextDecoder();
  shaders.forEach(function (shader) {
    if (Number.isFinite(shader.bufferView)) {
      shader.code = textDecoder.decode(gltfScenegraph.getTypedArrayForBufferView(shader.bufferView));
    } else {
      throw new Error('KHR_techniques_webgl: no shader code');
    }
  });
  programs.forEach(function (program) {
    program.fragmentShader = shaders[program.fragmentShader];
    program.vertexShader = shaders[program.vertexShader];
  });
  techniques.forEach(function (technique) {
    technique.program = programs[technique.program];
  });
  return techniques;
}

function resolveValues(technique, gltfScenegraph) {
  var values = Object.assign({}, technique.values);
  Object.keys(technique.uniforms || {}).forEach(function (uniform) {
    if (technique.uniforms[uniform].value && !(uniform in values)) {
      values[uniform] = technique.uniforms[uniform].value;
    }
  });
  Object.keys(values).forEach(function (uniform) {
    if (_typeof(values[uniform]) === 'object' && values[uniform].index !== undefined) {
      values[uniform].texture = gltfScenegraph.getTexture(values[uniform].index);
    }
  });
  return values;
}
//# sourceMappingURL=KHR_techniques_webgl.js.map