import assert from '../utils/assert';
export function getTypedArrayForBufferView(json, buffers, bufferViewIndex) {
  var bufferView = json.bufferViews[bufferViewIndex];
  assert(bufferView);
  var bufferIndex = bufferView.buffer;
  var binChunk = buffers[bufferIndex];
  assert(binChunk);
  var byteOffset = (bufferView.byteOffset || 0) + binChunk.byteOffset;
  return new Uint8Array(binChunk.arrayBuffer, byteOffset, bufferView.byteLength);
}
export function getTypedArrayForImageData(json, buffers, imageIndex) {
  var image = json.images[imageIndex];
  var bufferViewIndex = json.bufferViews[image.bufferView];
  return getTypedArrayForBufferView(json, buffers, bufferViewIndex);
}
//# sourceMappingURL=get-typed-array.js.map