import encodeGLBSync from './lib/encode-glb';
export default {
  name: 'GLB',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync,
  binary: true,
  options: {
    glb: {}
  }
};

function encodeSync(glb, options) {
  const {
    byteOffset = 0
  } = options;
  const byteLength = encodeGLBSync(glb, null, byteOffset, options);
  const arrayBuffer = new ArrayBuffer(byteLength);
  const dataView = new DataView(arrayBuffer);
  encodeGLBSync(glb, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=glb-writer.js.map