import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import parseGLBSync from './lib/parse-glb';
var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
export default {
  id: 'glb',
  name: 'GLB',
  version: VERSION,
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  binary: true,
  parse: function () {
    var _parse = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(arrayBuffer, options) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", parseSync(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  parseSync: parseSync,
  options: {
    glb: {
      strict: false
    }
  }
};

function parseSync(arrayBuffer, options) {
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var glb = {};
  parseGLBSync(glb, arrayBuffer, byteOffset, options);
  return glb;
}
//# sourceMappingURL=glb-loader.js.map