import encodeGLBSync from './lib/encode-glb';
export default {
  name: 'GLB',
  extensions: ['glb'],
  mimeTypes: ['model/gltf-binary'],
  encodeSync: encodeSync,
  binary: true,
  options: {
    glb: {}
  }
};

function encodeSync(glb, options) {
  var _options$byteOffset = options.byteOffset,
      byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
  var byteLength = encodeGLBSync(glb, null, byteOffset, options);
  var arrayBuffer = new ArrayBuffer(byteLength);
  var dataView = new DataView(arrayBuffer);
  encodeGLBSync(glb, dataView, byteOffset, options);
  return arrayBuffer;
}
//# sourceMappingURL=glb-writer.js.map