import _regeneratorRuntime from "@babel/runtime/regenerator";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { parseGLTF } from './lib/parse-gltf';
var VERSION = typeof "2.2.7" !== 'undefined' ? "2.2.7" : 'latest';
var GLTFLoader = {
  id: 'gltf',
  name: 'glTF',
  version: VERSION,
  extensions: ['gltf', 'glb'],
  mimeTypes: ['model/gltf+json', 'model/gltf-binary'],
  text: true,
  binary: true,
  test: 'glTF',
  parse: parse,
  options: {
    gltf: {
      loadBuffers: true,
      loadImages: true,
      decompressMeshes: true,
      postProcess: true
    },
    uri: '',
    log: console
  },
  deprecatedOptions: {
    fetchImages: 'gltf.loadImages',
    createImages: 'gltf.loadImages',
    decompress: 'gltf.decompressMeshes',
    postProcess: 'gltf.postProcess',
    gltf: {
      decompress: 'gltf.decompressMeshes'
    }
  }
};
export default GLTFLoader;
export function parse(_x) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = _asyncToGenerator(_regeneratorRuntime.mark(function _callee(arrayBuffer) {
    var options,
        context,
        _options,
        _options$byteOffset,
        byteOffset,
        gltf,
        _args = arguments;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
            context = _args.length > 2 ? _args[2] : undefined;
            options = _objectSpread(_objectSpread({}, GLTFLoader.options), options);
            options.gltf = _objectSpread(_objectSpread({}, GLTFLoader.options.gltf), options.gltf);
            addDeprecatedGLTFOptions(options);
            _options = options, _options$byteOffset = _options.byteOffset, byteOffset = _options$byteOffset === void 0 ? 0 : _options$byteOffset;
            gltf = {};
            _context.next = 9;
            return parseGLTF(gltf, arrayBuffer, byteOffset, options, context);

          case 9:
            return _context.abrupt("return", _context.sent);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parse.apply(this, arguments);
}

function addDeprecatedGLTFOptions(options) {
  if ('fetchImages' in options) {
    options.gltf.loadImages = options.fetchImages;
  }

  if ('createImages' in options) {
    options.gltf.loadImages = options.createImages;
  }

  if ('fetchLinkedResources' in options) {
    options.gltf.fetchBuffers = options.fetchLinkedResources;
  }

  if ('decompress' in options) {
    options.gltf.decompressMeshes = options.decompress;
  }

  if ('decompress' in options.gltf) {
    options.gltf.decompressMeshes = options.gltf.decompress;
  }

  if ('postProcess' in options) {
    options.gltf.postProcess = options.postProcess;
  }
}
//# sourceMappingURL=gltf-loader.js.map