import _typeof from "@babel/runtime/helpers/esm/typeof";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _DEFAULT_SAMPLER;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import assert from './utils/assert';
import { getAccessorArrayTypeAndLength } from './gltf-utils/gltf-utils';
var COMPONENTS = {
  SCALAR: 1,
  VEC2: 2,
  VEC3: 3,
  VEC4: 4,
  MAT2: 4,
  MAT3: 9,
  MAT4: 16
};
var BYTES = {
  5120: 1,
  5121: 1,
  5122: 2,
  5123: 2,
  5125: 4,
  5126: 4
};
var GL_SAMPLER = {
  TEXTURE_MAG_FILTER: 0x2800,
  TEXTURE_MIN_FILTER: 0x2801,
  TEXTURE_WRAP_S: 0x2802,
  TEXTURE_WRAP_T: 0x2803,
  REPEAT: 0x2901,
  LINEAR: 0x2601,
  NEAREST_MIPMAP_LINEAR: 0x2702
};
var SAMPLER_PARAMETER_GLTF_TO_GL = {
  magFilter: GL_SAMPLER.TEXTURE_MAG_FILTER,
  minFilter: GL_SAMPLER.TEXTURE_MIN_FILTER,
  wrapS: GL_SAMPLER.TEXTURE_WRAP_S,
  wrapT: GL_SAMPLER.TEXTURE_WRAP_T
};
var DEFAULT_SAMPLER = (_DEFAULT_SAMPLER = {}, _defineProperty(_DEFAULT_SAMPLER, GL_SAMPLER.TEXTURE_MAG_FILTER, GL_SAMPLER.LINEAR), _defineProperty(_DEFAULT_SAMPLER, GL_SAMPLER.TEXTURE_MIN_FILTER, GL_SAMPLER.NEAREST_MIPMAP_LINEAR), _defineProperty(_DEFAULT_SAMPLER, GL_SAMPLER.TEXTURE_WRAP_S, GL_SAMPLER.REPEAT), _defineProperty(_DEFAULT_SAMPLER, GL_SAMPLER.TEXTURE_WRAP_, GL_SAMPLER.REPEAT), _DEFAULT_SAMPLER);

function getBytesFromComponentType(componentType) {
  return BYTES[componentType];
}

function getSizeFromAccessorType(type) {
  return COMPONENTS[type];
}

var GLTFPostProcessor = function () {
  function GLTFPostProcessor() {
    _classCallCheck(this, GLTFPostProcessor);
  }

  _createClass(GLTFPostProcessor, [{
    key: "postProcess",
    value: function postProcess(gltf) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var json = gltf.json,
          _gltf$buffers = gltf.buffers,
          buffers = _gltf$buffers === void 0 ? [] : _gltf$buffers,
          _gltf$images = gltf.images,
          images = _gltf$images === void 0 ? [] : _gltf$images,
          _gltf$baseUri = gltf.baseUri,
          baseUri = _gltf$baseUri === void 0 ? '' : _gltf$baseUri;
      assert(json);
      this.baseUri = baseUri;
      this.json = json;
      this.buffers = buffers;
      this.images = images;

      this._resolveTree(this.json, options);

      return this.json;
    }
  }, {
    key: "_resolveTree",
    value: function _resolveTree(json) {
      var _this = this;

      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (json.bufferViews) {
        json.bufferViews = json.bufferViews.map(function (bufView, i) {
          return _this._resolveBufferView(bufView, i);
        });
      }

      if (json.images) {
        json.images = json.images.map(function (image, i) {
          return _this._resolveImage(image, i);
        });
      }

      if (json.samplers) {
        json.samplers = json.samplers.map(function (sampler, i) {
          return _this._resolveSampler(sampler, i);
        });
      }

      if (json.textures) {
        json.textures = json.textures.map(function (texture, i) {
          return _this._resolveTexture(texture, i);
        });
      }

      if (json.accessors) {
        json.accessors = json.accessors.map(function (accessor, i) {
          return _this._resolveAccessor(accessor, i);
        });
      }

      if (json.materials) {
        json.materials = json.materials.map(function (material, i) {
          return _this._resolveMaterial(material, i);
        });
      }

      if (json.meshes) {
        json.meshes = json.meshes.map(function (mesh, i) {
          return _this._resolveMesh(mesh, i);
        });
      }

      if (json.nodes) {
        json.nodes = json.nodes.map(function (node, i) {
          return _this._resolveNode(node, i);
        });
      }

      if (json.skins) {
        json.skins = json.skins.map(function (skin, i) {
          return _this._resolveSkin(skin, i);
        });
      }

      if (json.scenes) {
        json.scenes = json.scenes.map(function (scene, i) {
          return _this._resolveScene(scene, i);
        });
      }

      if (json.scene !== undefined) {
        json.scene = json.scenes[this.json.scene];
      }
    }
  }, {
    key: "getScene",
    value: function getScene(index) {
      return this._get('scenes', index);
    }
  }, {
    key: "getNode",
    value: function getNode(index) {
      return this._get('nodes', index);
    }
  }, {
    key: "getSkin",
    value: function getSkin(index) {
      return this._get('skins', index);
    }
  }, {
    key: "getMesh",
    value: function getMesh(index) {
      return this._get('meshes', index);
    }
  }, {
    key: "getMaterial",
    value: function getMaterial(index) {
      return this._get('materials', index);
    }
  }, {
    key: "getAccessor",
    value: function getAccessor(index) {
      return this._get('accessors', index);
    }
  }, {
    key: "getCamera",
    value: function getCamera(index) {
      return null;
    }
  }, {
    key: "getTexture",
    value: function getTexture(index) {
      return this._get('textures', index);
    }
  }, {
    key: "getSampler",
    value: function getSampler(index) {
      return this._get('samplers', index);
    }
  }, {
    key: "getImage",
    value: function getImage(index) {
      return this._get('images', index);
    }
  }, {
    key: "getBufferView",
    value: function getBufferView(index) {
      return this._get('bufferViews', index);
    }
  }, {
    key: "getBuffer",
    value: function getBuffer(index) {
      return this._get('buffers', index);
    }
  }, {
    key: "_get",
    value: function _get(array, index) {
      if (_typeof(index) === 'object') {
        return index;
      }

      var object = this.json[array] && this.json[array][index];

      if (!object) {
        console.warn("glTF file error: Could not find ".concat(array, "[").concat(index, "]"));
      }

      return object;
    }
  }, {
    key: "_resolveScene",
    value: function _resolveScene(scene, index) {
      var _this2 = this;

      scene.id = scene.id || "scene-".concat(index);
      scene.nodes = (scene.nodes || []).map(function (node) {
        return _this2.getNode(node);
      });
      return scene;
    }
  }, {
    key: "_resolveNode",
    value: function _resolveNode(node, index) {
      var _this3 = this;

      node.id = node.id || "node-".concat(index);

      if (node.children) {
        node.children = node.children.map(function (child) {
          return _this3.getNode(child);
        });
      }

      if (node.mesh !== undefined) {
        node.mesh = this.getMesh(node.mesh);
      }

      if (node.camera !== undefined) {
        node.camera = this.getCamera(node.camera);
      }

      if (node.skin !== undefined) {
        node.skin = this.getSkin(node.skin);
      }

      return node;
    }
  }, {
    key: "_resolveSkin",
    value: function _resolveSkin(skin, index) {
      skin.id = skin.id || "skin-".concat(index);
      skin.inverseBindMatrices = this.getAccessor(skin.inverseBindMatrices);
      return skin;
    }
  }, {
    key: "_resolveMesh",
    value: function _resolveMesh(mesh, index) {
      var _this4 = this;

      mesh.id = mesh.id || "mesh-".concat(index);

      if (mesh.primitives) {
        mesh.primitives = mesh.primitives.map(function (primitive) {
          primitive = _objectSpread({}, primitive);
          var attributes = primitive.attributes;
          primitive.attributes = {};

          for (var attribute in attributes) {
            primitive.attributes[attribute] = _this4.getAccessor(attributes[attribute]);
          }

          if (primitive.indices !== undefined) {
            primitive.indices = _this4.getAccessor(primitive.indices);
          }

          if (primitive.material !== undefined) {
            primitive.material = _this4.getMaterial(primitive.material);
          }

          return primitive;
        });
      }

      return mesh;
    }
  }, {
    key: "_resolveMaterial",
    value: function _resolveMaterial(material, index) {
      material.id = material.id || "material-".concat(index);

      if (material.normalTexture) {
        material.normalTexture = _objectSpread({}, material.normalTexture);
        material.normalTexture.texture = this.getTexture(material.normalTexture.index);
      }

      if (material.occlusionTexture) {
        material.occlustionTexture = _objectSpread({}, material.occlustionTexture);
        material.occlusionTexture.texture = this.getTexture(material.occlusionTexture.index);
      }

      if (material.emissiveTexture) {
        material.emmisiveTexture = _objectSpread({}, material.emmisiveTexture);
        material.emissiveTexture.texture = this.getTexture(material.emissiveTexture.index);
      }

      if (material.pbrMetallicRoughness) {
        material.pbrMetallicRoughness = _objectSpread({}, material.pbrMetallicRoughness);
        var mr = material.pbrMetallicRoughness;

        if (mr.baseColorTexture) {
          mr.baseColorTexture = _objectSpread({}, mr.baseColorTexture);
          mr.baseColorTexture.texture = this.getTexture(mr.baseColorTexture.index);
        }

        if (mr.metallicRoughnessTexture) {
          mr.metallicRoughnessTexture = _objectSpread({}, mr.metallicRoughnessTexture);
          mr.metallicRoughnessTexture.texture = this.getTexture(mr.metallicRoughnessTexture.index);
        }
      }

      return material;
    }
  }, {
    key: "_resolveAccessor",
    value: function _resolveAccessor(accessor, index) {
      accessor.id = accessor.id || "accessor-".concat(index);

      if (accessor.bufferView !== undefined) {
        accessor.bufferView = this.getBufferView(accessor.bufferView);
      }

      accessor.bytesPerComponent = getBytesFromComponentType(accessor.componentType);
      accessor.components = getSizeFromAccessorType(accessor.type);
      accessor.bytesPerElement = accessor.bytesPerComponent * accessor.components;

      if (accessor.bufferView) {
        var buffer = accessor.bufferView.buffer;

        var _getAccessorArrayType = getAccessorArrayTypeAndLength(accessor, accessor.bufferView),
            ArrayType = _getAccessorArrayType.ArrayType,
            length = _getAccessorArrayType.length;

        var byteOffset = (accessor.bufferView.byteOffset || 0) + buffer.byteOffset;
        accessor.value = new ArrayType(buffer.arrayBuffer, byteOffset, length);
      }

      return accessor;
    }
  }, {
    key: "_resolveTexture",
    value: function _resolveTexture(texture, index) {
      texture.id = texture.id || "texture-".concat(index);
      texture.sampler = 'sampler' in texture ? this.getSampler(texture.sampler) : DEFAULT_SAMPLER;
      texture.source = this.getImage(texture.source);
      return texture;
    }
  }, {
    key: "_resolveSampler",
    value: function _resolveSampler(sampler, index) {
      sampler.id = sampler.id || "sampler-".concat(index);
      sampler.parameters = {};

      for (var key in sampler) {
        var glEnum = this._enumSamplerParameter(key);

        if (glEnum !== undefined) {
          sampler.parameters[glEnum] = sampler[key];
        }
      }

      return sampler;
    }
  }, {
    key: "_enumSamplerParameter",
    value: function _enumSamplerParameter(key) {
      return SAMPLER_PARAMETER_GLTF_TO_GL[key];
    }
  }, {
    key: "_resolveImage",
    value: function _resolveImage(image, index) {
      image.id = image.id || "image-".concat(index);

      if (image.bufferView !== undefined) {
        image.bufferView = this.getBufferView(image.bufferView);
      }

      var preloadedImage = this.images[index];

      if (preloadedImage) {
        image.image = preloadedImage;
      }

      return image;
    }
  }, {
    key: "_resolveBufferView",
    value: function _resolveBufferView(bufferView, index) {
      bufferView.id = bufferView.id || "bufferView-".concat(index);
      var bufferIndex = bufferView.buffer;
      bufferView.buffer = this.buffers[bufferIndex];
      var arrayBuffer = this.buffers[bufferIndex].arrayBuffer;
      var byteOffset = this.buffers[bufferIndex].byteOffset || 0;

      if ('byteOffset' in bufferView) {
        byteOffset += bufferView.byteOffset;
      }

      bufferView.data = new Uint8Array(arrayBuffer, byteOffset, bufferView.byteLength);
      return bufferView;
    }
  }, {
    key: "_resolveCamera",
    value: function _resolveCamera(camera, index) {
      camera.id = camera.id || "camera-".concat(index);

      if (camera.perspective) {}

      if (camera.orthographic) {}

      return camera;
    }
  }]);

  return GLTFPostProcessor;
}();

export default function postProcessGLTF(gltf, options) {
  return new GLTFPostProcessor().postProcess(gltf, options);
}
//# sourceMappingURL=post-process-gltf.js.map