"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertBuffersToNonIndexed = convertBuffersToNonIndexed;

function convertBuffersToNonIndexed(_ref) {
  var indices = _ref.indices,
      attributes = _ref.attributes;
  var geometry2 = new BufferGeometry();

  for (var name in attributes) {
    var attribute = attributes[name];
    var array = attribute.array;
    var itemSize = attribute.itemSize;
    var array2 = new array.constructor(indices.length * itemSize);
    var index = 0,
        index2 = 0;

    for (var i = 0, l = indices.length; i < l; i++) {
      index = indices[i] * itemSize;

      for (var j = 0; j < itemSize; j++) {
        array2[index2++] = array[index++];
      }
    }

    geometry2.addAttribute(name, new BufferAttribute(array2, itemSize));
  }

  var groups = this.groups;

  for (var i = 0, l = groups.length; i < l; i++) {
    var group = groups[i];
    geometry2.addGroup(group.start, group.count, group.materialIndex);
  }

  return geometry2;
}
//# sourceMappingURL=convert-to-non-indexed.js.map