import { GL } from '../constants';
import { getPrimitiveModeType } from '../primitives/modes';
import { assert } from '@loaders.gl/loader-utils';
export default function* primitiveIterator({
  indices,
  attributes,
  mode,
  start = 0,
  end
}) {
  if (indices) {
    indices = indices.values || indices.value || indices;
  }

  if (end === undefined) {
    if (indices) {
      end = indices.length;
    }
  }

  const info = {
    attributes,
    type: getPrimitiveModeType(mode)
  };
  let i = start;

  while (i < end) {
    switch (mode) {
      case GL.POINTS:
        info.i1 = i;
        i += 1;
        break;

      case GL.LINES:
        info.i1 = i;
        info.i2 = i + 1;
        i += 2;
        break;

      case GL.LINE_STRIP:
        info.i1 = i;
        info.i2 = i + 1;
        i += 1;
        break;

      case GL.LINE_LOOP:
        info.i1 = i;
        info.i2 = i + 1;
        i += 1;
        break;

      case GL.TRIANGLES:
        info.i1 = i;
        info.i2 = i + 1;
        info.i3 = i + 2;
        i += 3;
        break;

      case GL.TRIANGLE_STRIP:
        info.i1 = i;
        info.i2 = i + 1;
        i += 1;
        break;

      case GL.TRIANGLE_FAN:
        info.i1 = 1;
        info.i2 = i;
        info.i2 = i + 1;
        i += 1;
        break;

      default:
        assert(false);
    }

    if (indices) {
      if ('i1' in info) {
        info.i1 = indices[info.i1];
        info.i2 = indices[info.i2];
        info.i3 = indices[info.i3];
      }
    }

    yield info;
  }
}
//# sourceMappingURL=primitive-iterator.js.map