import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _GL_TYPE_TO_ARRAY_TYP;

import { GL_TYPE as GL } from '../constants';
var GL_TYPE_TO_ARRAY_TYPE = (_GL_TYPE_TO_ARRAY_TYP = {}, _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.DOUBLE, Float64Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.FLOAT, Float32Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.UNSIGNED_SHORT, Uint16Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.UNSIGNED_INT, Uint32Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.UNSIGNED_BYTE, Uint8Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.BYTE, Int8Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.SHORT, Int16Array), _defineProperty(_GL_TYPE_TO_ARRAY_TYP, GL.INT, Int32Array), _GL_TYPE_TO_ARRAY_TYP);
var NAME_TO_GL_TYPE = {
  DOUBLE: GL.DOUBLE,
  FLOAT: GL.FLOAT,
  UNSIGNED_SHORT: GL.UNSIGNED_SHORT,
  UNSIGNED_INT: GL.UNSIGNED_INT,
  UNSIGNED_BYTE: GL.UNSIGNED_BYTE,
  BYTE: GL.BYTE,
  SHORT: GL.SHORT,
  INT: GL.INT
};
var ERR_TYPE_CONVERSION = 'Failed to convert GL type';

var GLType = function () {
  function GLType() {
    _classCallCheck(this, GLType);
  }

  _createClass(GLType, null, [{
    key: "fromTypedArray",
    value: function fromTypedArray(arrayOrType) {
      arrayOrType = ArrayBuffer.isView(arrayOrType) ? arrayOrType.constructor : arrayOrType;

      for (var glType in GL_TYPE_TO_ARRAY_TYPE) {
        var ArrayType = GL_TYPE_TO_ARRAY_TYPE[glType];

        if (ArrayType === arrayOrType) {
          return glType;
        }
      }

      throw new Error(ERR_TYPE_CONVERSION);
    }
  }, {
    key: "fromName",
    value: function fromName(name) {
      var glType = NAME_TO_GL_TYPE[name];

      if (!glType) {
        throw new Error(ERR_TYPE_CONVERSION);
      }

      return glType;
    }
  }, {
    key: "getArrayType",
    value: function getArrayType(glType) {
      var clamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      switch (glType) {
        case GL.UNSIGNED_SHORT_5_6_5:
        case GL.UNSIGNED_SHORT_4_4_4_4:
        case GL.UNSIGNED_SHORT_5_5_5_1:
          return Uint16Array;

        default:
          var ArrayType = GL_TYPE_TO_ARRAY_TYPE[glType];

          if (!ArrayType) {
            throw new Error(ERR_TYPE_CONVERSION);
          }

          return ArrayType;
      }
    }
  }, {
    key: "getByteSize",
    value: function getByteSize(glType) {
      var ArrayType = GLType.getArrayType(glType);
      return ArrayType.BYTES_PER_ELEMENT;
    }
  }, {
    key: "validate",
    value: function validate(glType) {
      return Boolean(GLType.getArrayType(glType));
    }
  }, {
    key: "createTypedArray",
    value: function createTypedArray(glType, buffer) {
      var byteOffset = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var length = arguments.length > 3 ? arguments[3] : undefined;

      if (length === undefined) {
        length = (buffer.byteLength - byteOffset) / GLType.getByteSize(glType);
      }

      var ArrayType = GLType.getArrayType(glType);
      return new ArrayType(buffer, byteOffset, length);
    }
  }]);

  return GLType;
}();

export { GLType as default };
//# sourceMappingURL=gl-type.js.map