import _regeneratorRuntime from "@babel/runtime/regenerator";

var _marked = _regeneratorRuntime.mark(primitiveIterator);

import { GL } from '../constants';
import { getPrimitiveModeType } from '../primitives/modes';
import { assert } from '@loaders.gl/loader-utils';
export default function primitiveIterator(_ref) {
  var indices, attributes, mode, _ref$start, start, end, info, i;

  return _regeneratorRuntime.wrap(function primitiveIterator$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          indices = _ref.indices, attributes = _ref.attributes, mode = _ref.mode, _ref$start = _ref.start, start = _ref$start === void 0 ? 0 : _ref$start, end = _ref.end;

          if (indices) {
            indices = indices.values || indices.value || indices;
          }

          if (end === undefined) {
            if (indices) {
              end = indices.length;
            }
          }

          info = {
            attributes: attributes,
            type: getPrimitiveModeType(mode)
          };
          i = start;

        case 5:
          if (!(i < end)) {
            _context.next = 44;
            break;
          }

          _context.t0 = mode;
          _context.next = _context.t0 === GL.POINTS ? 9 : _context.t0 === GL.LINES ? 12 : _context.t0 === GL.LINE_STRIP ? 16 : _context.t0 === GL.LINE_LOOP ? 20 : _context.t0 === GL.TRIANGLES ? 24 : _context.t0 === GL.TRIANGLE_STRIP ? 29 : _context.t0 === GL.TRIANGLE_FAN ? 33 : 38;
          break;

        case 9:
          info.i1 = i;
          i += 1;
          return _context.abrupt("break", 39);

        case 12:
          info.i1 = i;
          info.i2 = i + 1;
          i += 2;
          return _context.abrupt("break", 39);

        case 16:
          info.i1 = i;
          info.i2 = i + 1;
          i += 1;
          return _context.abrupt("break", 39);

        case 20:
          info.i1 = i;
          info.i2 = i + 1;
          i += 1;
          return _context.abrupt("break", 39);

        case 24:
          info.i1 = i;
          info.i2 = i + 1;
          info.i3 = i + 2;
          i += 3;
          return _context.abrupt("break", 39);

        case 29:
          info.i1 = i;
          info.i2 = i + 1;
          i += 1;
          return _context.abrupt("break", 39);

        case 33:
          info.i1 = 1;
          info.i2 = i;
          info.i2 = i + 1;
          i += 1;
          return _context.abrupt("break", 39);

        case 38:
          assert(false);

        case 39:
          if (indices) {
            if ('i1' in info) {
              info.i1 = indices[info.i1];
              info.i2 = indices[info.i2];
              info.i3 = indices[info.i3];
            }
          }

          _context.next = 42;
          return info;

        case 42:
          _context.next = 5;
          break;

        case 44:
        case "end":
          return _context.stop();
      }
    }
  }, _marked);
}
//# sourceMappingURL=primitive-iterator.js.map