"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrimitiveModeType = getPrimitiveModeType;
exports.isPrimitiveModeExpandable = isPrimitiveModeExpandable;
exports.getPrimitiveModeExpandedLength = getPrimitiveModeExpandedLength;

var _constants = require("../constants");

var _assert = _interopRequireDefault(require("../utils/assert"));

function getPrimitiveModeType(mode) {
  switch (mode) {
    case _constants.GL.POINTS:
      return _constants.GL.POINTS;

    case _constants.GL.LINES:
    case _constants.GL.LINE_STRIP:
    case _constants.GL.LINE_LOOP:
      return _constants.GL.LINES;

    case _constants.GL.TRIANGLES:
    case _constants.GL.TRIANGLE_STRIP:
    case _constants.GL.TRIANGLE_FAN:
      return _constants.GL.TRIANGLES;

    default:
      return (0, _assert["default"])(false);
  }
}

function isPrimitiveModeExpandable(mode) {
  switch (mode) {
    case _constants.GL.LINE_STRIP:
    case _constants.GL.LINE_LOOP:
    case _constants.GL.TRIANGLE_STRIP:
    case _constants.GL.TRIANGLE_FAN:
      return true;

    default:
      return false;
  }
}

function getPrimitiveModeExpandedLength(mode, length) {
  switch (mode) {
    case _constants.GL.POINTS:
      return length;

    case _constants.GL.LINES:
      return length;

    case _constants.GL.LINE_STRIP:
      return length;

    case _constants.GL.LINE_LOOP:
      return length + 1;

    case _constants.GL.TRIANGLES:
      return length;

    case _constants.GL.TRIANGLE_STRIP:
    case _constants.GL.TRIANGLE_FAN:
      return (length - 2) * 3;

    default:
      return (0, _assert["default"])(false);
  }
}
//# sourceMappingURL=modes.js.map