import { Vector3 } from '@math.gl/core';
import { getPositions } from './get-attribute-from-geometry';
export function computeBoundingSphere(geometry, boundingBox) {
  const positions = getPositions(geometry);
  const center = getBoundingBox(center);
  box.setFromBufferAttribute(position);
  box.getCenter(center);
  var maxRadiusSq = 0;

  for (const position of attributeIterator(positions)) {
    vector.x = position[0];
    vector.y = position[1];
    vector.z = position[2];
    maxRadiusSq = Math.max(maxRadiusSq, center.distanceToSquared(vector));
  }

  const radius = Math.sqrt(maxRadiusSq);
  assert(Number.isFinite(radius));
  return {
    center,
    radius
  };
}
//# sourceMappingURL=compute-bounding-sphere.js.map