"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = parseMVT;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _vectorTile = require("@mapbox/vector-tile");

var _pbf = _interopRequireDefault(require("pbf"));

var _transformToLocalRange = require("./transform-to-local-range");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function parseMVT(input, options) {
  if (input.byteLength === 0) {
    return [];
  }

  var tile = new _vectorTile.VectorTile(new _pbf["default"](input));
  var loaderOptions = options.mvt;
  var features = [];
  var selectedLayers = Array.isArray(loaderOptions.layers) ? loaderOptions.layers : Object.keys(tile.layers);
  selectedLayers.forEach(function (layerName) {
    var vectorTileLayer = tile.layers[layerName];

    var featureOptions = _objectSpread(_objectSpread({}, loaderOptions), {}, {
      layerName: layerName
    });

    if (!vectorTileLayer) {
      return;
    }

    for (var i = 0; i < vectorTileLayer.length; i++) {
      var vectorTileFeature = vectorTileLayer.feature(i);
      var decodedFeature = getDecodedFeature(vectorTileFeature, featureOptions);
      features.push(decodedFeature);
    }
  });
  return features;
}

function getDecodedFeature(feature) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var wgs84Coordinates = options.coordinates === 'wgs84';
  var hasTileIndex = options.tileIndex && options.tileIndex.x && options.tileIndex.y && options.tileIndex.z;

  if (wgs84Coordinates && !hasTileIndex) {
    throw new Error('MVT Loader: WGS84 coordinates need tileIndex property. Check documentation.');
  }

  var decodedFeature = wgs84Coordinates && hasTileIndex ? feature.toGeoJSON(options.tileIndex.x, options.tileIndex.y, options.tileIndex.z) : (0, _transformToLocalRange.transformCoordinates)(feature, _transformToLocalRange.transformToLocalCoordinates);

  if (options.layerProperty) {
    decodedFeature.properties[options.layerProperty] = options.layerName;
  }

  return decodedFeature;
}
//# sourceMappingURL=parse-mvt.js.map