"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToLocalCoordinates = transformToLocalCoordinates;
exports.transformCoordinates = transformCoordinates;
var geometryTypes = ['Unknown', 'Point', 'LineString', 'Polygon'];

function transformToLocalCoordinates(line, feature) {
  for (var i = 0; i < line.length; i++) {
    var point = line[i];
    line[i] = [point.x / feature.extent, point.y / feature.extent];
  }
}

function transformCoordinates(feature) {
  var transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (coordinates, feature_) {
    return coordinates;
  };
  var type = geometryTypes[feature.type];
  var coordinates = feature.loadGeometry();

  switch (feature.type) {
    case 1:
      var points = [];

      for (var i = 0; i < coordinates.length; i++) {
        points[i] = coordinates[i][0];
      }

      coordinates = points;
      transform(coordinates, feature);
      break;

    case 2:
      for (var _i = 0; _i < coordinates.length; _i++) {
        transform(coordinates[_i], feature);
      }

      break;

    case 3:
      coordinates = classifyRings(coordinates);

      for (var _i2 = 0; _i2 < coordinates.length; _i2++) {
        for (var j = 0; j < coordinates[_i2].length; j++) {
          transform(coordinates[_i2][j], feature);
        }
      }

      break;

    default:
      break;
  }

  return generateJSON(type, feature, coordinates);
}

function generateJSON(type, feature, coordinates) {
  var geometryType = type;

  if (coordinates.length === 1) {
    coordinates = coordinates[0];
  } else {
    geometryType = "Multi".concat(type);
  }

  var jsonResult = {
    type: 'Feature',
    geometry: {
      type: geometryType,
      coordinates: coordinates
    },
    properties: feature.properties || {}
  };

  if ('id' in feature) {
    jsonResult.id = feature.id;
  }

  return jsonResult;
}

function classifyRings(rings) {
  var len = rings.length;
  if (len <= 1) return [rings];
  var polygons = [];
  var polygon;
  var ccw;

  for (var i = 0; i < len; i++) {
    var area = signedArea(rings[i]);

    if (area === 0) {
      continue;
    }

    if (ccw === undefined) ccw = area < 0;

    if (ccw === area < 0) {
      if (polygon) {
        polygons.push(polygon);
      }

      polygon = [rings[i]];
    } else {
      polygon.push(rings[i]);
    }
  }

  if (polygon) polygons.push(polygon);
  return polygons;
}

function signedArea(ring) {
  var length = ring.length;
  var sum = 0;
  var p1;
  var p2;

  for (var i = 0, j = length - 1; i < length; j = i++) {
    p1 = ring[i];
    p2 = ring[j];
    sum += (p2.x - p1.x) * (p1.y + p2.y);
  }

  return sum;
}
//# sourceMappingURL=transform-to-local-range.js.map