"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = loadQuantizedMesh;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _loaderUtils = require("@loaders.gl/loader-utils");

var _decodeQuantizedMesh = _interopRequireWildcard(require("./decode-quantized-mesh"));

function getMeshAttributes(vertexData, header, bounds) {
  var minHeight = header.minHeight,
      maxHeight = header.maxHeight;

  var _ref = bounds || [0, 0, 1, 1],
      _ref2 = (0, _slicedToArray2["default"])(_ref, 4),
      minX = _ref2[0],
      minY = _ref2[1],
      maxX = _ref2[2],
      maxY = _ref2[3];

  var xScale = maxX - minX;
  var yScale = maxY - minY;
  var zScale = maxHeight - minHeight;
  var nCoords = vertexData.length / 3;
  var positions = new Float32Array(nCoords * 3);
  var texCoords = new Float32Array(nCoords * 2);

  for (var i = 0; i < nCoords; i++) {
    var x = vertexData[i] / 32767;
    var y = vertexData[i + nCoords] / 32767;
    var z = vertexData[i + nCoords * 2] / 32767;
    positions[3 * i + 0] = x * xScale + minX;
    positions[3 * i + 1] = y * yScale + minY;
    positions[3 * i + 2] = z * zScale + minHeight;
    texCoords[2 * i + 0] = x;
    texCoords[2 * i + 1] = y;
  }

  return {
    POSITION: {
      value: positions,
      size: 3
    },
    TEXCOORD_0: {
      value: texCoords,
      size: 2
    }
  };
}

function getTileMesh(arrayBuffer, options) {
  if (!arrayBuffer) {
    return null;
  }

  var bounds = options.bounds;

  var _decode = (0, _decodeQuantizedMesh["default"])(arrayBuffer, _decodeQuantizedMesh.DECODING_STEPS.triangleIndices),
      header = _decode.header,
      vertexData = _decode.vertexData,
      triangleIndices = _decode.triangleIndices;

  var attributes = getMeshAttributes(vertexData, header, bounds);
  return {
    loaderData: {
      header: {}
    },
    header: {
      vertexCount: triangleIndices.length,
      boundingBox: (0, _loaderUtils.getMeshBoundingBox)(attributes)
    },
    mode: 4,
    indices: {
      value: triangleIndices,
      size: 1
    },
    attributes: attributes
  };
}

function loadQuantizedMesh(arrayBuffer, options) {
  return getTileMesh(arrayBuffer, options['quantized-mesh']);
}
//# sourceMappingURL=parse-quantized-mesh.js.map