"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = loadTerrain;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _martini = _interopRequireDefault(require("@mapbox/martini"));

var _loaderUtils = require("@loaders.gl/loader-utils");

function getTerrain(imageData, tileSize, elevationDecoder) {
  var rScaler = elevationDecoder.rScaler,
      bScaler = elevationDecoder.bScaler,
      gScaler = elevationDecoder.gScaler,
      offset = elevationDecoder.offset;
  var gridSize = tileSize + 1;
  var terrain = new Float32Array(gridSize * gridSize);

  for (var i = 0, y = 0; y < tileSize; y++) {
    for (var x = 0; x < tileSize; x++, i++) {
      var k = i * 4;
      var r = imageData[k + 0];
      var g = imageData[k + 1];
      var b = imageData[k + 2];
      terrain[i + y] = r * rScaler + g * gScaler + b * bScaler + offset;
    }
  }

  for (var _i = gridSize * (gridSize - 1), _x = 0; _x < gridSize - 1; _x++, _i++) {
    terrain[_i] = terrain[_i - gridSize];
  }

  for (var _i2 = gridSize - 1, _y = 0; _y < gridSize; _y++, _i2 += gridSize) {
    terrain[_i2] = terrain[_i2 - 1];
  }

  return terrain;
}

function getMeshAttributes(vertices, terrain, tileSize, bounds) {
  var gridSize = tileSize + 1;
  var numOfVerticies = vertices.length / 2;
  var positions = new Float32Array(numOfVerticies * 3);
  var texCoords = new Float32Array(numOfVerticies * 2);

  var _ref = bounds || [0, 0, tileSize, tileSize],
      _ref2 = (0, _slicedToArray2["default"])(_ref, 4),
      minX = _ref2[0],
      minY = _ref2[1],
      maxX = _ref2[2],
      maxY = _ref2[3];

  var xScale = (maxX - minX) / tileSize;
  var yScale = (maxY - minY) / tileSize;

  for (var i = 0; i < numOfVerticies; i++) {
    var x = vertices[i * 2];
    var y = vertices[i * 2 + 1];
    var pixelIdx = y * gridSize + x;
    positions[3 * i + 0] = x * xScale + minX;
    positions[3 * i + 1] = -y * yScale + maxY;
    positions[3 * i + 2] = terrain[pixelIdx];
    texCoords[2 * i + 0] = x / tileSize;
    texCoords[2 * i + 1] = y / tileSize;
  }

  return {
    POSITION: {
      value: positions,
      size: 3
    },
    TEXCOORD_0: {
      value: texCoords,
      size: 2
    }
  };
}

function getMartiniTileMesh(terrainImage, terrainOptions) {
  if (terrainImage === null) {
    return null;
  }

  var meshMaxError = terrainOptions.meshMaxError,
      bounds = terrainOptions.bounds,
      elevationDecoder = terrainOptions.elevationDecoder;
  var data = terrainImage.data;
  var tileSize = terrainImage.width;
  var gridSize = tileSize + 1;
  var terrain = getTerrain(data, tileSize, elevationDecoder);
  var martini = new _martini["default"](gridSize);
  var tile = martini.createTile(terrain);

  var _tile$getMesh = tile.getMesh(meshMaxError),
      vertices = _tile$getMesh.vertices,
      triangles = _tile$getMesh.triangles;

  var attributes = getMeshAttributes(vertices, terrain, tileSize, bounds);
  return {
    loaderData: {
      header: {}
    },
    header: {
      vertexCount: triangles.length,
      boundingBox: (0, _loaderUtils.getMeshBoundingBox)(attributes)
    },
    mode: 4,
    indices: {
      value: triangles,
      size: 1
    },
    attributes: attributes
  };
}

function loadTerrain(_x2, _x3, _x4) {
  return _loadTerrain.apply(this, arguments);
}

function _loadTerrain() {
  _loadTerrain = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options, context) {
    var image;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            options.image = options.image || {};
            options.image.type = 'data';
            _context.next = 4;
            return context.parse(arrayBuffer, options, options.baseUri);

          case 4:
            image = _context.sent;
            return _context.abrupt("return", getMartiniTileMesh(image, options.terrain));

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _loadTerrain.apply(this, arguments);
}
//# sourceMappingURL=parse-terrain.js.map