(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/bundle.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "../../node_modules/@babel/runtime/helpers/esm/classCallCheck.js":
/*!************************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@babel/runtime/helpers/esm/classCallCheck.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _classCallCheck; });
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

/***/ }),

/***/ "../../node_modules/@babel/runtime/helpers/esm/createClass.js":
/*!*********************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@babel/runtime/helpers/esm/createClass.js ***!
  \*********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _createClass; });
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

/***/ }),

/***/ "../../node_modules/@mapbox/martini/index.js":
/*!****************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@mapbox/martini/index.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Martini; });

class Martini {
    constructor(gridSize = 257) {
        this.gridSize = gridSize;
        const tileSize = gridSize - 1;
        if (tileSize & (tileSize - 1)) throw new Error(
            `Expected grid size to be 2^n+1, got ${gridSize}.`);

        this.numTriangles = tileSize * tileSize * 2 - 2;
        this.numParentTriangles = this.numTriangles - tileSize * tileSize;

        this.indices = new Uint32Array(this.gridSize * this.gridSize);

        // coordinates for all possible triangles in an RTIN tile
        this.coords = new Uint16Array(this.numTriangles * 4);

        // get triangle coordinates from its index in an implicit binary tree
        for (let i = 0; i < this.numTriangles; i++) {
            let id = i + 2;
            let ax = 0, ay = 0, bx = 0, by = 0, cx = 0, cy = 0;
            if (id & 1) {
                bx = by = cx = tileSize; // bottom-left triangle
            } else {
                ax = ay = cy = tileSize; // top-right triangle
            }
            while ((id >>= 1) > 1) {
                const mx = (ax + bx) >> 1;
                const my = (ay + by) >> 1;

                if (id & 1) { // left half
                    bx = ax; by = ay;
                    ax = cx; ay = cy;
                } else { // right half
                    ax = bx; ay = by;
                    bx = cx; by = cy;
                }
                cx = mx; cy = my;
            }
            const k = i * 4;
            this.coords[k + 0] = ax;
            this.coords[k + 1] = ay;
            this.coords[k + 2] = bx;
            this.coords[k + 3] = by;
        }
    }

    createTile(terrain) {
        return new Tile(terrain, this);
    }
}

class Tile {
    constructor(terrain, martini) {
        const size = martini.gridSize;
        if (terrain.length !== size * size) throw new Error(
            `Expected terrain data of length ${size * size} (${size} x ${size}), got ${terrain.length}.`);

        this.terrain = terrain;
        this.martini = martini;
        this.errors = new Float32Array(terrain.length);
        this.update();
    }

    update() {
        const {numTriangles, numParentTriangles, coords, gridSize: size} = this.martini;
        const {terrain, errors} = this;

        // iterate over all possible triangles, starting from the smallest level
        for (let i = numTriangles - 1; i >= 0; i--) {
            const k = i * 4;
            const ax = coords[k + 0];
            const ay = coords[k + 1];
            const bx = coords[k + 2];
            const by = coords[k + 3];
            const mx = (ax + bx) >> 1;
            const my = (ay + by) >> 1;
            const cx = mx + my - ay;
            const cy = my + ax - mx;

            // calculate error in the middle of the long edge of the triangle
            const interpolatedHeight = (terrain[ay * size + ax] + terrain[by * size + bx]) / 2;
            const middleIndex = my * size + mx;
            const middleError = Math.abs(interpolatedHeight - terrain[middleIndex]);

            errors[middleIndex] = Math.max(errors[middleIndex], middleError);

            if (i < numParentTriangles) { // bigger triangles; accumulate error with children
                const leftChildIndex = ((ay + cy) >> 1) * size + ((ax + cx) >> 1);
                const rightChildIndex = ((by + cy) >> 1) * size + ((bx + cx) >> 1);
                errors[middleIndex] = Math.max(errors[middleIndex], errors[leftChildIndex], errors[rightChildIndex]);
            }
        }
    }

    getMesh(maxError = 0) {
        const {gridSize: size, indices} = this.martini;
        const {errors} = this;
        let numVertices = 0;
        let numTriangles = 0;
        const max = size - 1;

        // use an index grid to keep track of vertices that were already used to avoid duplication
        indices.fill(0);

        // retrieve mesh in two stages that both traverse the error map:
        // - countElements: find used vertices (and assign each an index), and count triangles (for minimum allocation)
        // - processTriangle: fill the allocated vertices & triangles typed arrays

        function countElements(ax, ay, bx, by, cx, cy) {
            const mx = (ax + bx) >> 1;
            const my = (ay + by) >> 1;

            if (Math.abs(ax - cx) + Math.abs(ay - cy) > 1 && errors[my * size + mx] > maxError) {
                countElements(cx, cy, ax, ay, mx, my);
                countElements(bx, by, cx, cy, mx, my);
            } else {
                indices[ay * size + ax] = indices[ay * size + ax] || ++numVertices;
                indices[by * size + bx] = indices[by * size + bx] || ++numVertices;
                indices[cy * size + cx] = indices[cy * size + cx] || ++numVertices;
                numTriangles++;
            }
        }
        countElements(0, 0, max, max, max, 0);
        countElements(max, max, 0, 0, 0, max);

        const vertices = new Uint16Array(numVertices * 2);
        const triangles = new Uint32Array(numTriangles * 3);
        let triIndex = 0;

        function processTriangle(ax, ay, bx, by, cx, cy) {
            const mx = (ax + bx) >> 1;
            const my = (ay + by) >> 1;

            if (Math.abs(ax - cx) + Math.abs(ay - cy) > 1 && errors[my * size + mx] > maxError) {
                // triangle doesn't approximate the surface well enough; drill down further
                processTriangle(cx, cy, ax, ay, mx, my);
                processTriangle(bx, by, cx, cy, mx, my);

            } else {
                // add a triangle
                const a = indices[ay * size + ax] - 1;
                const b = indices[by * size + bx] - 1;
                const c = indices[cy * size + cx] - 1;

                vertices[2 * a] = ax;
                vertices[2 * a + 1] = ay;

                vertices[2 * b] = bx;
                vertices[2 * b + 1] = by;

                vertices[2 * c] = cx;
                vertices[2 * c + 1] = cy;

                triangles[triIndex++] = a;
                triangles[triIndex++] = b;
                triangles[triIndex++] = c;
            }
        }
        processTriangle(0, 0, max, max, max, 0);
        processTriangle(max, max, 0, 0, 0, max);

        return {vertices, triangles};
    }
}


/***/ }),

/***/ "../../node_modules/@probe.gl/stats/dist/esm/index.js":
/*!*************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@probe.gl/stats/dist/esm/index.js ***!
  \*************************************************************************************/
/*! exports provided: Stats, Stat, _getHiResTimestamp */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _lib_stats__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/stats */ "../../node_modules/@probe.gl/stats/dist/esm/lib/stats.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Stats", function() { return _lib_stats__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _lib_stat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/stat */ "../../node_modules/@probe.gl/stats/dist/esm/lib/stat.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Stat", function() { return _lib_stat__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _utils_hi_res_timestamp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/hi-res-timestamp */ "../../node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "_getHiResTimestamp", function() { return _utils_hi_res_timestamp__WEBPACK_IMPORTED_MODULE_2__["default"]; });




//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@probe.gl/stats/dist/esm/lib/stat.js":
/*!****************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@probe.gl/stats/dist/esm/lib/stat.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Stat; });
/* harmony import */ var _babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/classCallCheck */ "../../node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/createClass */ "../../node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _utils_hi_res_timestamp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/hi-res-timestamp */ "../../node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js");




var Stat = function () {
  function Stat(name, type) {
    Object(_babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, Stat);

    this.name = name;
    this.type = type;
    this.sampleSize = 1;
    this.reset();
  }

  Object(_babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(Stat, [{
    key: "setSampleSize",
    value: function setSampleSize(samples) {
      this.sampleSize = samples;
      return this;
    }
  }, {
    key: "incrementCount",
    value: function incrementCount() {
      this.addCount(1);
      return this;
    }
  }, {
    key: "decrementCount",
    value: function decrementCount() {
      this.subtractCount(1);
      return this;
    }
  }, {
    key: "addCount",
    value: function addCount(value) {
      this._count += value;
      this._samples++;

      this._checkSampling();

      return this;
    }
  }, {
    key: "subtractCount",
    value: function subtractCount(value) {
      this._count -= value;
      this._samples++;

      this._checkSampling();

      return this;
    }
  }, {
    key: "addTime",
    value: function addTime(time) {
      this._time += time;
      this.lastTiming = time;
      this._samples++;

      this._checkSampling();

      return this;
    }
  }, {
    key: "timeStart",
    value: function timeStart() {
      this._startTime = Object(_utils_hi_res_timestamp__WEBPACK_IMPORTED_MODULE_2__["default"])();
      this._timerPending = true;
      return this;
    }
  }, {
    key: "timeEnd",
    value: function timeEnd() {
      if (!this._timerPending) {
        return this;
      }

      this.addTime(Object(_utils_hi_res_timestamp__WEBPACK_IMPORTED_MODULE_2__["default"])() - this._startTime);
      this._timerPending = false;

      this._checkSampling();

      return this;
    }
  }, {
    key: "getSampleAverageCount",
    value: function getSampleAverageCount() {
      return this.sampleSize > 0 ? this.lastSampleCount / this.sampleSize : 0;
    }
  }, {
    key: "getSampleAverageTime",
    value: function getSampleAverageTime() {
      return this.sampleSize > 0 ? this.lastSampleTime / this.sampleSize : 0;
    }
  }, {
    key: "getSampleHz",
    value: function getSampleHz() {
      return this.lastSampleTime > 0 ? this.sampleSize / (this.lastSampleTime / 1000) : 0;
    }
  }, {
    key: "getAverageCount",
    value: function getAverageCount() {
      return this.samples > 0 ? this.count / this.samples : 0;
    }
  }, {
    key: "getAverageTime",
    value: function getAverageTime() {
      return this.samples > 0 ? this.time / this.samples : 0;
    }
  }, {
    key: "getHz",
    value: function getHz() {
      return this.time > 0 ? this.samples / (this.time / 1000) : 0;
    }
  }, {
    key: "reset",
    value: function reset() {
      this.time = 0;
      this.count = 0;
      this.samples = 0;
      this.lastTiming = 0;
      this.lastSampleTime = 0;
      this.lastSampleCount = 0;
      this._count = 0;
      this._time = 0;
      this._samples = 0;
      this._startTime = 0;
      this._timerPending = false;
      return this;
    }
  }, {
    key: "_checkSampling",
    value: function _checkSampling() {
      if (this._samples === this.sampleSize) {
        this.lastSampleTime = this._time;
        this.lastSampleCount = this._count;
        this.count += this._count;
        this.time += this._time;
        this.samples += this._samples;
        this._time = 0;
        this._count = 0;
        this._samples = 0;
      }
    }
  }]);

  return Stat;
}();


//# sourceMappingURL=stat.js.map

/***/ }),

/***/ "../../node_modules/@probe.gl/stats/dist/esm/lib/stats.js":
/*!*****************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@probe.gl/stats/dist/esm/lib/stats.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Stats; });
/* harmony import */ var _babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/classCallCheck */ "../../node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/createClass */ "../../node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _stat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./stat */ "../../node_modules/@probe.gl/stats/dist/esm/lib/stat.js");




var Stats = function () {
  function Stats(_ref) {
    var id = _ref.id,
        stats = _ref.stats;

    Object(_babel_runtime_helpers_esm_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, Stats);

    this.id = id;
    this.stats = {};

    this._initializeStats(stats);

    Object.seal(this);
  }

  Object(_babel_runtime_helpers_esm_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(Stats, [{
    key: "get",
    value: function get(name) {
      var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'count';
      return this._getOrCreate({
        name: name,
        type: type
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      for (var key in this.stats) {
        this.stats[key].reset();
      }

      return this;
    }
  }, {
    key: "forEach",
    value: function forEach(fn) {
      for (var key in this.stats) {
        fn(this.stats[key]);
      }
    }
  }, {
    key: "getTable",
    value: function getTable() {
      var table = {};
      this.forEach(function (stat) {
        table[stat.name] = {
          time: stat.time || 0,
          count: stat.count || 0,
          average: stat.getAverageTime() || 0,
          hz: stat.getHz() || 0
        };
      });
      return table;
    }
  }, {
    key: "_initializeStats",
    value: function _initializeStats() {
      var _this = this;

      var stats = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      stats.forEach(function (stat) {
        return _this._getOrCreate(stat);
      });
    }
  }, {
    key: "_getOrCreate",
    value: function _getOrCreate(stat) {
      if (!stat || !stat.name) {
        return null;
      }

      var name = stat.name,
          type = stat.type;

      if (!this.stats[name]) {
        if (stat instanceof _stat__WEBPACK_IMPORTED_MODULE_2__["default"]) {
          this.stats[name] = stat;
        } else {
          this.stats[name] = new _stat__WEBPACK_IMPORTED_MODULE_2__["default"](name, type);
        }
      }

      return this.stats[name];
    }
  }, {
    key: "size",
    get: function get() {
      return Object.keys(this.stats).length;
    }
  }]);

  return Stats;
}();


//# sourceMappingURL=stats.js.map

/***/ }),

/***/ "../../node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js":
/*!******************************************************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/@probe.gl/stats/dist/esm/utils/hi-res-timestamp.js ***!
  \******************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return getHiResTimestamp; });
function getHiResTimestamp() {
  var timestamp;

  if (typeof window !== 'undefined' && window.performance) {
    timestamp = window.performance.now();
  } else if (typeof process !== 'undefined' && process.hrtime) {
    var timeParts = process.hrtime();
    timestamp = timeParts[0] * 1000 + timeParts[1] / 1e6;
  } else {
    timestamp = Date.now();
  }

  return timestamp;
}
//# sourceMappingURL=hi-res-timestamp.js.map
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../../../process/browser.js */ "../../node_modules/process/browser.js")))

/***/ }),

/***/ "../../node_modules/process/browser.js":
/*!**********************************************************************!*\
  !*** /Users/ibgreen/code/loaders.gl/node_modules/process/browser.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),

/***/ "../../node_modules/webpack/buildin/global.js":
/*!***********************************!*\
  !*** (webpack)/buildin/global.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ "../loader-utils/src/categories/mesh/mesh-utils.js":
/*!*********************************************************!*\
  !*** ../loader-utils/src/categories/mesh/mesh-utils.js ***!
  \*********************************************************/
/*! exports provided: getMeshSize, getMeshBoundingBox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMeshSize", function() { return getMeshSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMeshBoundingBox", function() { return getMeshBoundingBox; });
function getMeshSize(attributes) {
  let size = 0;
  for (const attributeName in attributes) {
    const attribute = attributes[attributeName];
    if (ArrayBuffer.isView(attribute)) {
      // @ts-ignore DataView doesn't have BYTES_PER_ELEMENT
      size += attribute.byteLength * attribute.BYTES_PER_ELEMENT;
    }
  }
  return size;
}

// eslint-disable-next-line complexity
function getMeshBoundingBox(attributes) {
  if (!attributes || !attributes.POSITION) {
    return null;
  }

  let minX = Infinity;
  let minY = Infinity;
  let minZ = Infinity;
  let maxX = -Infinity;
  let maxY = -Infinity;
  let maxZ = -Infinity;

  const positions = attributes.POSITION.value;
  const len = positions && positions.length;

  if (!len) {
    return null;
  }

  for (let i = 0; i < len; i += 3) {
    const x = positions[i];
    const y = positions[i + 1];
    const z = positions[i + 2];

    minX = x < minX ? x : minX;
    minY = y < minY ? y : minY;
    minZ = z < minZ ? z : minZ;

    maxX = x > maxX ? x : maxX;
    maxY = y > maxY ? y : maxY;
    maxZ = z > maxZ ? z : maxZ;
  }
  return [[minX, minY, minZ], [maxX, maxY, maxZ]];
}


/***/ }),

/***/ "../loader-utils/src/index.js":
/*!************************************!*\
  !*** ../loader-utils/src/index.js ***!
  \************************************/
/*! exports provided: createWorker, assert, isBrowser, isWorker, nodeVersion, self, window, global, document, validateLoaderVersion, getLibraryUrl, loadLibrary, getTransferList, parseJSON, padTo4Bytes, copyToArray, copyArrayBuffer, getZeroOffsetArrayBuffer, copyPaddedArrayBufferToDataView, copyPaddedStringToDataView, padStringToByteAlignment, copyStringToDataView, copyBinaryToDataView, getFirstCharacters, getMagicString, path, setPathPrefix, getPathPrefix, resolvePath, _addAliases, makeTextEncoderIterator, makeTextDecoderIterator, makeLineIterator, makeNumberedLineIterator, RequestScheduler, _getMeshSize, getMeshBoundingBox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _lib_create_worker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/create-worker */ "../loader-utils/src/lib/create-worker.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createWorker", function() { return _lib_create_worker__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _lib_env_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/env-utils/assert */ "../loader-utils/src/lib/env-utils/assert.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "assert", function() { return _lib_env_utils_assert__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/env-utils/globals */ "../loader-utils/src/lib/env-utils/globals.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isBrowser", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["isBrowser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isWorker", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["isWorker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "nodeVersion", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["nodeVersion"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "self", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["self"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "window", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["window"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "global", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["global"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "document", function() { return _lib_env_utils_globals__WEBPACK_IMPORTED_MODULE_2__["document"]; });

/* harmony import */ var _lib_validate_loader_version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/validate-loader-version */ "../loader-utils/src/lib/validate-loader-version.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "validateLoaderVersion", function() { return _lib_validate_loader_version__WEBPACK_IMPORTED_MODULE_3__["validateLoaderVersion"]; });

/* harmony import */ var _lib_library_utils_library_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./lib/library-utils/library-utils */ "../loader-utils/src/lib/library-utils/library-utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getLibraryUrl", function() { return _lib_library_utils_library_utils__WEBPACK_IMPORTED_MODULE_4__["getLibraryUrl"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadLibrary", function() { return _lib_library_utils_library_utils__WEBPACK_IMPORTED_MODULE_4__["loadLibrary"]; });

/* harmony import */ var _lib_worker_utils_get_transfer_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lib/worker-utils/get-transfer-list */ "../loader-utils/src/lib/worker-utils/get-transfer-list.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getTransferList", function() { return _lib_worker_utils_get_transfer_list__WEBPACK_IMPORTED_MODULE_5__["getTransferList"]; });

/* harmony import */ var _lib_parser_utils_parse_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./lib/parser-utils/parse-json */ "../loader-utils/src/lib/parser-utils/parse-json.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseJSON", function() { return _lib_parser_utils_parse_json__WEBPACK_IMPORTED_MODULE_6__["parseJSON"]; });

/* harmony import */ var _lib_binary_utils_memory_copy_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./lib/binary-utils/memory-copy-utils */ "../loader-utils/src/lib/binary-utils/memory-copy-utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "padTo4Bytes", function() { return _lib_binary_utils_memory_copy_utils__WEBPACK_IMPORTED_MODULE_7__["padTo4Bytes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyToArray", function() { return _lib_binary_utils_memory_copy_utils__WEBPACK_IMPORTED_MODULE_7__["copyToArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyArrayBuffer", function() { return _lib_binary_utils_memory_copy_utils__WEBPACK_IMPORTED_MODULE_7__["copyArrayBuffer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getZeroOffsetArrayBuffer", function() { return _lib_binary_utils_memory_copy_utils__WEBPACK_IMPORTED_MODULE_7__["getZeroOffsetArrayBuffer"]; });

/* harmony import */ var _lib_binary_utils_binary_copy_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./lib/binary-utils/binary-copy-utils */ "../loader-utils/src/lib/binary-utils/binary-copy-utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyPaddedArrayBufferToDataView", function() { return _lib_binary_utils_binary_copy_utils__WEBPACK_IMPORTED_MODULE_8__["copyPaddedArrayBufferToDataView"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyPaddedStringToDataView", function() { return _lib_binary_utils_binary_copy_utils__WEBPACK_IMPORTED_MODULE_8__["copyPaddedStringToDataView"]; });

/* harmony import */ var _lib_binary_utils_encode_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./lib/binary-utils/encode-utils */ "../loader-utils/src/lib/binary-utils/encode-utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "padStringToByteAlignment", function() { return _lib_binary_utils_encode_utils__WEBPACK_IMPORTED_MODULE_9__["padStringToByteAlignment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyStringToDataView", function() { return _lib_binary_utils_encode_utils__WEBPACK_IMPORTED_MODULE_9__["copyStringToDataView"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "copyBinaryToDataView", function() { return _lib_binary_utils_encode_utils__WEBPACK_IMPORTED_MODULE_9__["copyBinaryToDataView"]; });

/* harmony import */ var _lib_binary_utils_get_first_characters__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./lib/binary-utils/get-first-characters */ "../loader-utils/src/lib/binary-utils/get-first-characters.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getFirstCharacters", function() { return _lib_binary_utils_get_first_characters__WEBPACK_IMPORTED_MODULE_10__["getFirstCharacters"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMagicString", function() { return _lib_binary_utils_get_first_characters__WEBPACK_IMPORTED_MODULE_10__["getMagicString"]; });

/* harmony import */ var _lib_path_utils_path__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./lib/path-utils/path */ "../loader-utils/src/lib/path-utils/path.js");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "path", function() { return _lib_path_utils_path__WEBPACK_IMPORTED_MODULE_11__; });
/* harmony import */ var _lib_path_utils_file_aliases__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./lib/path-utils/file-aliases */ "../loader-utils/src/lib/path-utils/file-aliases.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "setPathPrefix", function() { return _lib_path_utils_file_aliases__WEBPACK_IMPORTED_MODULE_12__["setPathPrefix"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getPathPrefix", function() { return _lib_path_utils_file_aliases__WEBPACK_IMPORTED_MODULE_12__["getPathPrefix"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "resolvePath", function() { return _lib_path_utils_file_aliases__WEBPACK_IMPORTED_MODULE_12__["resolvePath"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "_addAliases", function() { return _lib_path_utils_file_aliases__WEBPACK_IMPORTED_MODULE_12__["addAliases"]; });

/* harmony import */ var _lib_iterator_utils_text_iterators__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./lib/iterator-utils/text-iterators */ "../loader-utils/src/lib/iterator-utils/text-iterators.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeTextEncoderIterator", function() { return _lib_iterator_utils_text_iterators__WEBPACK_IMPORTED_MODULE_13__["makeTextEncoderIterator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeTextDecoderIterator", function() { return _lib_iterator_utils_text_iterators__WEBPACK_IMPORTED_MODULE_13__["makeTextDecoderIterator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeLineIterator", function() { return _lib_iterator_utils_text_iterators__WEBPACK_IMPORTED_MODULE_13__["makeLineIterator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "makeNumberedLineIterator", function() { return _lib_iterator_utils_text_iterators__WEBPACK_IMPORTED_MODULE_13__["makeNumberedLineIterator"]; });

/* harmony import */ var _lib_request_utils_request_scheduler__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./lib/request-utils/request-scheduler */ "../loader-utils/src/lib/request-utils/request-scheduler.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequestScheduler", function() { return _lib_request_utils_request_scheduler__WEBPACK_IMPORTED_MODULE_14__["default"]; });

/* harmony import */ var _categories_mesh_mesh_utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./categories/mesh/mesh-utils */ "../loader-utils/src/categories/mesh/mesh-utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "_getMeshSize", function() { return _categories_mesh_mesh_utils__WEBPACK_IMPORTED_MODULE_15__["getMeshSize"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getMeshBoundingBox", function() { return _categories_mesh_mesh_utils__WEBPACK_IMPORTED_MODULE_15__["getMeshBoundingBox"]; });



// GENERAL UTILS



// LOADER UTILS


// LIBRARY UTILS


// WORKER UTILS


// PARSER UTILS


// MEMORY COPY UTILS





// PATH UTILS






// ITERATOR UTILS



// REQUEST UTILS


// MESH CATEGORY UTILS
// Note: Should move to category specific module if code size increases



/***/ }),

/***/ "../loader-utils/src/lib/binary-utils/binary-copy-utils.js":
/*!*****************************************************************!*\
  !*** ../loader-utils/src/lib/binary-utils/binary-copy-utils.js ***!
  \*****************************************************************/
/*! exports provided: copyPaddedArrayBufferToDataView, copyPaddedStringToDataView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyPaddedArrayBufferToDataView", function() { return copyPaddedArrayBufferToDataView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyPaddedStringToDataView", function() { return copyPaddedStringToDataView; });
/* harmony import */ var _memory_copy_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./memory-copy-utils */ "../loader-utils/src/lib/binary-utils/memory-copy-utils.js");
/* global TextEncoder */


function copyPaddedArrayBufferToDataView(dataView, byteOffset, sourceBuffer) {
  const paddedLength = Object(_memory_copy_utils__WEBPACK_IMPORTED_MODULE_0__["padTo4Bytes"])(sourceBuffer.byteLength);
  const padLength = paddedLength - sourceBuffer.byteLength;

  if (dataView) {
    // Copy array
    const targetArray = new Uint8Array(
      dataView.buffer,
      dataView.byteOffset + byteOffset,
      sourceBuffer.byteLength
    );
    const sourceArray = new Uint8Array(sourceBuffer);
    targetArray.set(sourceArray);

    // Add PADDING
    for (let i = 0; i < padLength; ++i) {
      // json chunk is padded with spaces (ASCII 0x20)
      dataView.setUint8(byteOffset + sourceBuffer.byteLength + i, 0x20);
    }
  }
  byteOffset += paddedLength;
  return byteOffset;
}

function copyPaddedStringToDataView(dataView, byteOffset, string) {
  const textEncoder = new TextEncoder();
  // PERFORMANCE IDEA: We encode twice, once to get size and once to store
  // PERFORMANCE IDEA: Use TextEncoder.encodeInto() to avoid temporary copy
  const stringBuffer = textEncoder.encode(string);

  byteOffset = copyPaddedArrayBufferToDataView(dataView, byteOffset, stringBuffer);

  return byteOffset;
}


/***/ }),

/***/ "../loader-utils/src/lib/binary-utils/encode-utils.js":
/*!************************************************************!*\
  !*** ../loader-utils/src/lib/binary-utils/encode-utils.js ***!
  \************************************************************/
/*! exports provided: padStringToByteAlignment, copyStringToDataView, copyBinaryToDataView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "padStringToByteAlignment", function() { return padStringToByteAlignment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyStringToDataView", function() { return copyStringToDataView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyBinaryToDataView", function() { return copyBinaryToDataView; });
// UTILITIES

// PERFORMANCE IDEA: No need to copy string twice...
function padStringToByteAlignment(string, byteAlignment) {
  const length = string.length;
  const paddedLength = Math.ceil(length / byteAlignment) * byteAlignment; // Round up to the required alignment
  const padding = paddedLength - length;
  let whitespace = '';
  for (let i = 0; i < padding; ++i) {
    whitespace += ' ';
  }
  return string + whitespace;
}

function copyStringToDataView(dataView, byteOffset, string, byteLength) {
  if (dataView) {
    for (let i = 0; i < byteLength; i++) {
      dataView.setUint8(byteOffset + i, string.charCodeAt(i));
    }
  }
  return byteOffset + byteLength;
}

function copyBinaryToDataView(dataView, byteOffset, binary, byteLength) {
  if (dataView) {
    for (let i = 0; i < byteLength; i++) {
      dataView.setUint8(byteOffset + i, binary[i]);
      byteOffset++;
    }
  }
  return byteOffset + byteLength;
}


/***/ }),

/***/ "../loader-utils/src/lib/binary-utils/get-first-characters.js":
/*!********************************************************************!*\
  !*** ../loader-utils/src/lib/binary-utils/get-first-characters.js ***!
  \********************************************************************/
/*! exports provided: getFirstCharacters, getMagicString */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFirstCharacters", function() { return getFirstCharacters; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getMagicString", function() { return getMagicString; });
function getFirstCharacters(data, length = 5) {
  if (typeof data === 'string') {
    return data.slice(0, length);
  } else if (ArrayBuffer.isView(data)) {
    // Typed Arrays can have offsets into underlying buffer
    return getMagicString(data.buffer, data.byteOffset, length);
  } else if (data instanceof ArrayBuffer) {
    const byteOffset = 0;
    return getMagicString(data, byteOffset, length);
  }
  return '';
}

function getMagicString(arrayBuffer, byteOffset, length) {
  if (arrayBuffer.byteLength <= byteOffset + length) {
    return '';
  }
  const dataView = new DataView(arrayBuffer);
  let magic = '';
  for (let i = 0; i < length; i++) {
    magic += String.fromCharCode(dataView.getUint8(byteOffset + i));
  }
  return magic;
}


/***/ }),

/***/ "../loader-utils/src/lib/binary-utils/memory-copy-utils.js":
/*!*****************************************************************!*\
  !*** ../loader-utils/src/lib/binary-utils/memory-copy-utils.js ***!
  \*****************************************************************/
/*! exports provided: padTo4Bytes, getZeroOffsetArrayBuffer, copyArrayBuffer, copyToArray */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "padTo4Bytes", function() { return padTo4Bytes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getZeroOffsetArrayBuffer", function() { return getZeroOffsetArrayBuffer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyArrayBuffer", function() { return copyArrayBuffer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "copyToArray", function() { return copyToArray; });
function padTo4Bytes(byteLength) {
  return (byteLength + 3) & ~3;
}

// Copy a view of an ArrayBuffer into new ArrayBuffer with byteOffset = 0
function getZeroOffsetArrayBuffer(arrayBuffer, byteOffset, byteLength) {
  const subArray = byteLength
    ? new Uint8Array(arrayBuffer).subarray(byteOffset, byteOffset + byteLength)
    : new Uint8Array(arrayBuffer).subarray(byteOffset);
  const arrayCopy = new Uint8Array(subArray);
  return arrayCopy.buffer;
}

/* Creates a new Uint8Array based on two different ArrayBuffers
 * @private
 * @param {ArrayBuffers} buffer1 The first buffer.
 * @param {ArrayBuffers} buffer2 The second buffer.
 * @return {ArrayBuffers} The new ArrayBuffer created out of the two.
 */
function copyArrayBuffer(
  targetBuffer,
  sourceBuffer,
  byteOffset,
  byteLength = sourceBuffer.byteLength
) {
  const targetArray = new Uint8Array(targetBuffer, byteOffset, byteLength);
  const sourceArray = new Uint8Array(sourceBuffer);
  targetArray.set(sourceArray);
  return targetBuffer;
}

/**
 * Copy from source to target at the targetOffset
 *
 * @param {ArrayBuffer|any} source - The data to copy
 * @param {any} target - The destination to copy data into
 * @param {Number} targetOffset - The start offset into target to place the copied data
 *
 * @return {Number} Returns the new offset taking into account proper padding
 */
function copyToArray(source, target, targetOffset) {
  let sourceArray;

  if (source instanceof ArrayBuffer) {
    sourceArray = new Uint8Array(source);
  } else {
    // Pack buffer onto the big target array
    //
    // 'source.data.buffer' could be a view onto a larger buffer.
    // We MUST use this constructor to ensure the byteOffset and byteLength is
    // set to correct values from 'source.data' and not the underlying
    // buffer for target.set() to work properly.
    const srcByteOffset = source.byteOffset;
    const srcByteLength = source.byteLength;
    sourceArray = new Uint8Array(source.buffer, srcByteOffset, srcByteLength);
  }

  // Pack buffer onto the big target array
  target.set(sourceArray, targetOffset);

  return targetOffset + padTo4Bytes(sourceArray.byteLength);
}


/***/ }),

/***/ "../loader-utils/src/lib/create-worker.js":
/*!************************************************!*\
  !*** ../loader-utils/src/lib/create-worker.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return createWorker; });
/* harmony import */ var _worker_utils_get_transfer_list__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./worker-utils/get-transfer-list */ "../loader-utils/src/lib/worker-utils/get-transfer-list.js");
/* harmony import */ var _validate_loader_version__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validate-loader-version */ "../loader-utils/src/lib/validate-loader-version.js");
/* eslint-disable no-restricted-globals */
/* global TextDecoder, self */




function createWorker(loader) {
  // TODO - explain when this happens? Just a sanity check? Throw an error or log a warning?
  if (typeof self === 'undefined') {
    return;
  }

  let requestId = 0;
  const parse = (arraybuffer, options = {}, url) =>
    new Promise((resolve, reject) => {
      const id = requestId++;

      const onMessage = ({data}) => {
        if (!data || data.id !== id) {
          // not ours
          return;
        }
        switch (data.type) {
          case 'parse-done':
            self.removeEventListener('message', onMessage);
            resolve(data.result);
            break;

          case 'parse-error':
            self.removeEventListener('message', onMessage);
            reject(data.message);
            break;

          default:
          // ignore
        }
      };
      self.addEventListener('message', onMessage);
      // Ask the main thread to decode data
      // @ts-ignore self is WorkerGlobalScope
      self.postMessage({type: 'parse', id, arraybuffer, options, url}, [arraybuffer]);
    });

  self.onmessage = async evt => {
    const {data} = evt;

    try {
      if (!isKnownMessage(data, loader.name)) {
        return;
      }

      Object(_validate_loader_version__WEBPACK_IMPORTED_MODULE_1__["validateLoaderVersion"])(loader, data.source.split('@')[1]);

      const {arraybuffer, byteOffset = 0, byteLength = 0, options = {}} = data;

      const result = await parseData({
        loader,
        arraybuffer,
        byteOffset,
        byteLength,
        options,
        context: {parse}
      });
      const transferList = Object(_worker_utils_get_transfer_list__WEBPACK_IMPORTED_MODULE_0__["getTransferList"])(result);
      // @ts-ignore self is WorkerGlobalScope
      self.postMessage({type: 'done', result}, transferList);
    } catch (error) {
      // @ts-ignore self is WorkerGlobalScope
      self.postMessage({type: 'error', message: error.message});
    }
  };
}

// TODO - Support byteOffset and byteLength (enabling parsing of embedded binaries without copies)
// TODO - Why not support async loader.parse* funcs here?
// TODO - Why not reuse a common function instead of reimplementing loader.parse* selection logic? Keeping loader small?
// TODO - Lack of appropriate parser functions can be detected when we create worker, no need to wait until parse
async function parseData({loader, arraybuffer, byteOffset, byteLength, options, context}) {
  let data;
  let parser;
  if (loader.parseSync || loader.parse) {
    data = arraybuffer;
    parser = loader.parseSync || loader.parse;
  } else if (loader.parseTextSync) {
    const textDecoder = new TextDecoder();
    data = textDecoder.decode(arraybuffer);
    parser = loader.parseTextSync;
  } else {
    throw new Error(`Could not load data with ${loader.name} loader`);
  }

  // TODO - proper merge in of loader options...
  options = {
    ...options,
    modules: (loader && loader.options && loader.options.modules) || {},
    worker: false
  };

  return await parser(data, {...options}, context, loader);
}

// Filter out noise messages sent to workers
function isKnownMessage(data, name) {
  return data && data.type === 'parse' && data.source && data.source.startsWith('loaders.gl');
}

/*
function checkMessage(evt, name) {
  switch (evt.data && evt.data.source) {
    // Ignore known noise event from react-dev-tools bridge, webpack build progress etc...
    case 'react-devtools-bridge':
    case 'react-devtools-content-script':
    case 'react-devtools-detector':
      return false;
    default:
      // fall through
  }

  switch (evt.data && evt.data.type) {
    case 'webpackProgress':
    case 'webpackOk':
      return false;
    default:
      // Enable to debug messages
      // const message = `${name.toLowerCase()}-worker: ignoring unknown message`;
      // console.log(message, evt.data, evt); // eslint-disable-line
      return false;
  }
}
*/


/***/ }),

/***/ "../loader-utils/src/lib/env-utils/assert.js":
/*!***************************************************!*\
  !*** ../loader-utils/src/lib/env-utils/assert.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return assert; });
// Replacement for the external assert method to reduce bundle size
// Note: We don't use the second "message" argument in calling code,
// so no need to support it here
function assert(condition, message) {
  if (!condition) {
    throw new Error(message || 'loader assertion failed.');
  }
}


/***/ }),

/***/ "../loader-utils/src/lib/env-utils/globals.js":
/*!****************************************************!*\
  !*** ../loader-utils/src/lib/env-utils/globals.js ***!
  \****************************************************/
/*! exports provided: self, window, global, document, isBrowser, isWorker, nodeVersion */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(global, process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "self", function() { return self_; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "window", function() { return window_; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "global", function() { return global_; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "document", function() { return document_; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isBrowser", function() { return isBrowser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isWorker", function() { return isWorker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nodeVersion", function() { return nodeVersion; });
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Purpose: include this in your module to avoids adding dependencies on
// micro modules like 'global' and 'is-browser';

// @ts-nocheck
/* eslint-disable no-restricted-globals */
/* global process, window, global, document, self, importScripts */
const globals = {
  self: typeof self !== 'undefined' && self,
  window: typeof window !== 'undefined' && window,
  global: typeof global !== 'undefined' && global,
  document: typeof document !== 'undefined' && document
};

const self_ = globals.self || globals.window || globals.global;
const window_ = globals.window || globals.self || globals.global;
const global_ = globals.global || globals.self || globals.window;
const document_ = globals.document || {};



const isBrowser =
  typeof process !== 'object' || String(process) !== '[object process]' || process.browser;

const isWorker = typeof importScripts === 'function';

// Extract node major version
const matches =
  typeof process !== 'undefined' && process.version && process.version.match(/v([0-9]*)/);
const nodeVersion = (matches && parseFloat(matches[1])) || 0;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../../../node_modules/webpack/buildin/global.js */ "../../node_modules/webpack/buildin/global.js"), __webpack_require__(/*! ./../../../../../node_modules/process/browser.js */ "../../node_modules/process/browser.js")))

/***/ }),

/***/ "../loader-utils/src/lib/iterator-utils/text-iterators.js":
/*!****************************************************************!*\
  !*** ../loader-utils/src/lib/iterator-utils/text-iterators.js ***!
  \****************************************************************/
/*! exports provided: makeTextDecoderIterator, makeTextEncoderIterator, makeLineIterator, makeNumberedLineIterator */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeTextDecoderIterator", function() { return makeTextDecoderIterator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeTextEncoderIterator", function() { return makeTextEncoderIterator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeLineIterator", function() { return makeLineIterator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "makeNumberedLineIterator", function() { return makeNumberedLineIterator; });
// TextDecoder iterators
// TextDecoder will keep any partial undecoded bytes between calls to `decode`

/* global TextDecoder, TextEncoder */

async function* makeTextDecoderIterator(arrayBufferIterator, options) {
  const textDecoder = new TextDecoder(options);
  for await (const arrayBuffer of arrayBufferIterator) {
    yield typeof arrayBuffer === 'string'
      ? arrayBuffer
      : textDecoder.decode(arrayBuffer, {stream: true});
  }
}

// TextEncoder iterator
// TODO - this is not useful unless min chunk size is given
// TextEncoder will keep any partial undecoded bytes between calls to `encode`
// If iterator does not yield strings, assume arrayBuffer and return unencoded

async function* makeTextEncoderIterator(textIterator, options) {
  const textEncoder = new TextEncoder();
  for await (const text of textIterator) {
    yield typeof text === 'string' ? textEncoder.encode(text) : text;
  }
}

/**
 * @param textIterator async iterable yielding strings
 * @returns an async iterable over lines
 * See http://2ality.com/2018/04/async-iter-nodejs.html
 */

async function* makeLineIterator(textIterator) {
  let previous = '';
  for await (const textChunk of textIterator) {
    previous += textChunk;
    let eolIndex;
    while ((eolIndex = previous.indexOf('\n')) >= 0) {
      // line includes the EOL
      const line = previous.slice(0, eolIndex + 1);
      previous = previous.slice(eolIndex + 1);
      yield line;
    }
  }

  if (previous.length > 0) {
    yield previous;
  }
}

/**
 * @param lineIterator async iterable yielding lines
 * @returns async iterable yielding numbered lines
 *
 * See http://2ality.com/2018/04/async-iter-nodejs.html
 */
async function* makeNumberedLineIterator(lineIterator) {
  let counter = 1;
  for await (const line of lineIterator) {
    yield {counter, line};
    counter++;
  }
}


/***/ }),

/***/ "../loader-utils/src/lib/library-utils/library-utils.js":
/*!**************************************************************!*\
  !*** ../loader-utils/src/lib/library-utils/library-utils.js ***!
  \**************************************************************/
/*! exports provided: loadLibrary, getLibraryUrl */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadLibrary", function() { return loadLibrary; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLibraryUrl", function() { return getLibraryUrl; });
/* harmony import */ var _env_utils_globals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../env-utils/globals */ "../loader-utils/src/lib/env-utils/globals.js");
/* harmony import */ var _require_utils_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./require-utils.node */ 0);
/* harmony import */ var _require_utils_node__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_require_utils_node__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _env_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../env-utils/assert */ "../loader-utils/src/lib/env-utils/assert.js");
/* global fetch, document */




// TODO - unpkg.com doesn't seem to have a `latest` specifier for alpha releases...
const LATEST = 'beta';

// __VERSION__ is injected by babel-plugin-version-inline
// @ts-ignore TS2304: Cannot find name '__VERSION__'.
const VERSION =  true ? "2.2.7" : undefined;

const loadLibraryPromises = {}; // promises

// Dynamically loads a library ("module")
async function loadLibrary(libraryUrl, moduleName = null, options = {}) {
  if (moduleName) {
    libraryUrl = getLibraryUrl(libraryUrl, moduleName, options);
  }

  // Ensure libraries are only loaded once
  loadLibraryPromises[libraryUrl] =
    loadLibraryPromises[libraryUrl] || loadLibraryFromFile(libraryUrl);
  return await loadLibraryPromises[libraryUrl];
}

// TODO - sort out how to resolve paths for main/worker and dev/prod
function getLibraryUrl(library, moduleName, options) {
  // Allow application to import and supply libraries through `options.modules`
  const modules = options.modules || {};
  if (modules[library]) {
    return modules[library];
  }

  // Load from local files, not from CDN scripts in Node.js
  // TODO - needs to locate the modules directory when installed!
  if (!_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isBrowser"]) {
    return `modules/${moduleName}/dist/libs/${library}`;
  }

  // In browser, load from external scripts
  if (options.CDN) {
    Object(_env_utils_assert__WEBPACK_IMPORTED_MODULE_2__["default"])(options.CDN.startsWith('http'));
    return `${options.CDN}/${moduleName}@${VERSION}/dist/libs/${library}`;
  }

  // TODO - loading inside workers requires paths relative to worker script location...
  if (_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isWorker"]) {
    return `../src/libs/${library}`;
  }

  return `modules/${moduleName}/src/libs/${library}`;
}

async function loadLibraryFromFile(libraryUrl) {
  if (libraryUrl.endsWith('wasm')) {
    const response = await fetch(libraryUrl);
    return await response.arrayBuffer();
  }

  if (!_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isBrowser"]) {
    return Object(_require_utils_node__WEBPACK_IMPORTED_MODULE_1__["requireFromFile"])(libraryUrl);
  }
  if (_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isWorker"]) {
    /* global importScripts */
    return importScripts(libraryUrl);
  }
  // TODO - fix - should be more secure than string parsing since observes CORS
  // if (isBrowser) {
  //   return await loadScriptFromFile(libraryUrl);
  // }

  const response = await fetch(libraryUrl);
  const scriptSource = await response.text();
  return loadLibraryFromString(scriptSource, libraryUrl);
}

/*
async function loadScriptFromFile(libraryUrl) {
  const script = document.createElement('script');
  script.src = libraryUrl;
  return await new Promise((resolve, reject) => {
    script.onload = data => {
      resolve(data);
    };
    script.onerror = reject;
  });
}
*/

// TODO - Needs security audit...
//  - Raw eval call
//  - Potentially bypasses CORS
// Upside is that this separates fetching and parsing
// we could create a`LibraryLoader` or`ModuleLoader`
function loadLibraryFromString(scriptSource, id) {
  if (!_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isBrowser"]) {
    return Object(_require_utils_node__WEBPACK_IMPORTED_MODULE_1__["requireFromString"])(scriptSource, id);
  }

  if (_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["isWorker"]) {
    // Use lvalue trick to make eval run in global scope
    eval.call(_env_utils_globals__WEBPACK_IMPORTED_MODULE_0__["global"], scriptSource); // eslint-disable-line no-eval
    // https://stackoverflow.com/questions/9107240/1-evalthis-vs-evalthis-in-javascript
    // http://perfectionkills.com/global-eval-what-are-the-options/
    return null;
  }

  const script = document.createElement('script');
  script.id = id;
  // most browsers like a separate text node but some throw an error. The second method covers those.
  try {
    script.appendChild(document.createTextNode(scriptSource));
  } catch (e) {
    script.text = scriptSource;
  }
  document.body.appendChild(script);
  return null;
}

// TODO - technique for module injection into worker, from THREE.DracoLoader...
/*
function combineWorkerWithLibrary(worker, jsContent) {
  var fn = wWorker.toString();
  var body = [
    '// injected',
    jsContent,
    '',
    '// worker',
    fn.substring(fn.indexOf('{') + 1, fn.lastIndexOf('}'))
  ].join('\n');
  this.workerSourceURL = URL.createObjectURL(new Blob([body]));
}
*/


/***/ }),

/***/ "../loader-utils/src/lib/parser-utils/parse-json.js":
/*!**********************************************************!*\
  !*** ../loader-utils/src/lib/parser-utils/parse-json.js ***!
  \**********************************************************/
/*! exports provided: parseJSON */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseJSON", function() { return parseJSON; });
/* harmony import */ var _binary_utils_get_first_characters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../binary-utils/get-first-characters */ "../loader-utils/src/lib/binary-utils/get-first-characters.js");


// Minimal JSON parser with a meaningful error message
function parseJSON(string) {
  try {
    return JSON.parse(string);
  } catch (_) {
    throw new Error(`Failed to parse JSON from data starting with "${Object(_binary_utils_get_first_characters__WEBPACK_IMPORTED_MODULE_0__["getFirstCharacters"])(string)}"`);
  }
}


/***/ }),

/***/ "../loader-utils/src/lib/path-utils/file-aliases.js":
/*!**********************************************************!*\
  !*** ../loader-utils/src/lib/path-utils/file-aliases.js ***!
  \**********************************************************/
/*! exports provided: setPathPrefix, getPathPrefix, addAliases, resolvePath */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setPathPrefix", function() { return setPathPrefix; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getPathPrefix", function() { return getPathPrefix; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addAliases", function() { return addAliases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resolvePath", function() { return resolvePath; });
// Simple file alias mechanisms for tests.

let pathPrefix = '';
const fileAliases = {};

/*
 * Set a relative path prefix
 */
function setPathPrefix(prefix) {
  pathPrefix = prefix;
}

function getPathPrefix() {
  return pathPrefix;
}

// Note: addAliases are an experimental export,
function addAliases(aliases) {
  Object.assign(fileAliases, aliases);
}

function resolvePath(filename) {
  for (const alias in fileAliases) {
    if (filename.startsWith(alias)) {
      const replacement = fileAliases[alias];
      filename = filename.replace(alias, replacement);
    }
  }
  if (!filename.startsWith('http://') && !filename.startsWith('https://')) {
    filename = `${pathPrefix}${filename}`;
  }
  return filename;
}


/***/ }),

/***/ "../loader-utils/src/lib/path-utils/path.js":
/*!**************************************************!*\
  !*** ../loader-utils/src/lib/path-utils/path.js ***!
  \**************************************************/
/*! exports provided: dirname */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dirname", function() { return dirname; });
// Beginning of a minimal implementation of the Node.js path API, that doesn't pull in big polyfills.
function dirname(url) {
  const slashIndex = url && url.lastIndexOf('/');
  return slashIndex >= 0 ? url.substr(0, slashIndex) : '';
}


/***/ }),

/***/ "../loader-utils/src/lib/request-utils/request-scheduler.js":
/*!******************************************************************!*\
  !*** ../loader-utils/src/lib/request-utils/request-scheduler.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return RequestScheduler; });
/* harmony import */ var _probe_gl_stats__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @probe.gl/stats */ "../../node_modules/@probe.gl/stats/dist/esm/index.js");
// TODO - this should move to core when test cases are more complete

/* global setTimeout */


const STAT_QUEUED_REQUESTS = 'Queued Requests';
const STAT_ACTIVE_REQUESTS = 'Active Requests';
const STAT_CANCELLED_REQUESTS = 'Cancelled Requests';
const STAT_QUEUED_REQUESTS_EVER = 'Queued Requests Ever';
const STAT_ACTIVE_REQUESTS_EVER = 'Active Requests Ever';

const DEFAULT_PROPS = {
  id: 'request-scheduler',
  // Specifies if the request scheduler should throttle incoming requests, mainly for comparative testing
  throttleRequests: true,
  // The maximum number of simultaneous active requests. Un-throttled requests do not observe this limit.
  maxRequests: 6
};

// TODO - Track requests globally, across multiple servers
class RequestScheduler {
  constructor(props = {}) {
    this.props = {...DEFAULT_PROPS, ...props};

    // Tracks the number of active requests and prioritizes/cancels queued requests.
    this.requestQueue = [];
    this.activeRequestCount = 0;
    this.requestMap = new Map();

    // Returns the statistics used by the request scheduler.
    this.stats = new _probe_gl_stats__WEBPACK_IMPORTED_MODULE_0__["Stats"]({id: props.id});
    this.stats.get(STAT_QUEUED_REQUESTS);
    this.stats.get(STAT_ACTIVE_REQUESTS);
    this.stats.get(STAT_CANCELLED_REQUESTS);
    this.stats.get(STAT_QUEUED_REQUESTS_EVER);
    this.stats.get(STAT_ACTIVE_REQUESTS_EVER);

    this._deferredUpdate = null;
  }

  // Called by an application that wants to issue a request, without having it deeply queued
  // Parameter `getPriority` will be called when request "slots" open up,
  //    allowing the caller to update priority or cancel the request
  //    Highest priority executes first, priority < 0 cancels the request
  // Returns: a promise that resolves to a request token when the request can be issued without queueing,
  //    or `false` if the request has been cancelled (by getPriority)
  scheduleRequest(handle, getPriority = () => 0) {
    // Allows throttling to be disabled
    if (!this.props.throttleRequests) {
      return Promise.resolve({done: () => {}});
    }

    // dedupe
    if (this.requestMap.has(handle)) {
      return this.requestMap.get(handle);
    }

    const request = {handle, getPriority};
    const promise = new Promise(resolve => {
      request.resolve = resolve;
      return request;
    });

    this.requestQueue.push(request);
    this.requestMap.set(handle, promise);
    this._issueNewRequests();
    return promise;
  }

  // PRIVATE

  _issueRequest(request) {
    const {handle, resolve} = request;
    let isDone = false;

    const done = () => {
      // can only be called once
      if (!isDone) {
        isDone = true;

        // Stop tracking a request - it has completed, failed, cancelled etc
        this.requestMap.delete(handle);
        this.activeRequestCount--;
        // A slot just freed up, see if any queued requests are waiting
        this._issueNewRequests();
      }
    };

    // Track this request
    this.activeRequestCount++;

    return resolve ? resolve({done}) : Promise.resolve({done});
  }

  // We check requests asynchronously, to prevent multiple updates
  _issueNewRequests() {
    if (!this._deferredUpdate) {
      this._deferredUpdate = setTimeout(() => this._issueNewRequestsAsync(), 0);
    }
  }

  // Refresh all requests and
  _issueNewRequestsAsync() {
    this._deferredUpdate = null;

    const freeSlots = Math.max(this.props.maxRequests - this.activeRequestCount, 0);

    if (freeSlots === 0) {
      return;
    }

    this._updateAllRequests();

    // Resolve pending promises for the top-priority requests
    for (let i = 0; i < freeSlots; ++i) {
      if (this.requestQueue.length > 0) {
        const request = this.requestQueue.shift();
        this._issueRequest(request);
      }
    }

    // Uncomment to debug
    // console.log(`${freeSlots} free slots, ${this.requestQueue.length} queued requests`);
  }

  // Ensure all requests have updated priorities, and that no longer valid requests are cancelled
  _updateAllRequests() {
    const requestQueue = this.requestQueue;
    for (let i = 0; i < requestQueue.length; ++i) {
      const request = requestQueue[i];
      if (!this._updateRequest(request)) {
        // Remove the element and make sure to adjust the counter to account for shortened array
        requestQueue.splice(i, 1);
        this.requestMap.delete(request.handle);
        i--;
      }
    }

    // Sort the remaining requests based on priority
    requestQueue.sort((a, b) => a.priority - b.priority);
  }

  // Update a single request by calling the callback
  _updateRequest(request) {
    request.priority = request.getPriority(request.handle); // eslint-disable-line callback-return

    // by returning a negative priority, the callback cancels the request
    if (request.priority < 0) {
      request.resolve(null);
      return false;
    }
    return true;
  }
}


/***/ }),

/***/ "../loader-utils/src/lib/validate-loader-version.js":
/*!**********************************************************!*\
  !*** ../loader-utils/src/lib/validate-loader-version.js ***!
  \**********************************************************/
/*! exports provided: validateLoaderVersion */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "validateLoaderVersion", function() { return validateLoaderVersion; });
/* harmony import */ var _env_utils_assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./env-utils/assert */ "../loader-utils/src/lib/env-utils/assert.js");


// __VERSION__ is injected by babel-plugin-version-inline

// @ts-ignore TS2304: Cannot find name '__VERSION__'.
const VERSION =  true ? "2.2.7" : undefined;

// Returns `true` if the two versions are compatible
function validateLoaderVersion(loader, coreVersion = VERSION) {
  Object(_env_utils_assert__WEBPACK_IMPORTED_MODULE_0__["default"])(loader, 'no loader provided');

  let loaderVersion = loader.version;
  if (!coreVersion || !loaderVersion) {
    return;
  }

  coreVersion = parseVersion(coreVersion);
  loaderVersion = parseVersion(loaderVersion);

  // TODO enable when fix the __version__ injection
  // assert(
  //   coreVersion.major === loaderVersion.major && coreVersion.minor <= loaderVersion.minor,
  //   `loader: ${loader.name} is not compatible. ${coreVersion.major}.${
  //     coreVersion.minor
  //   }+ is required.`
  // );
}

function parseVersion(version) {
  const parts = version.split('.').map(Number);
  return {major: parts[0], minor: parts[1]};
}


/***/ }),

/***/ "../loader-utils/src/lib/worker-utils/get-transfer-list.js":
/*!*****************************************************************!*\
  !*** ../loader-utils/src/lib/worker-utils/get-transfer-list.js ***!
  \*****************************************************************/
/*! exports provided: getTransferList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTransferList", function() { return getTransferList; });
// NOTE - there is a copy of this function is both in core and loader-utils
// core does not need all the utils in loader-utils, just this one.

/* global MessagePort, ImageBitmap, OffscreenCanvas */

// Returns an array of Transferrable objects that can be used with postMessage
// https://developer.mozilla.org/en-US/docs/Web/API/Worker/postMessage
function getTransferList(object, recursive = true, transfers) {
  // Make sure that items in the transfer list is unique
  const transfersSet = transfers || new Set();

  if (!object) {
    // ignore
  } else if (isTransferable(object)) {
    transfersSet.add(object);
  } else if (isTransferable(object.buffer)) {
    // Typed array
    transfersSet.add(object.buffer);
  } else if (recursive && typeof object === 'object') {
    for (const key in object) {
      // Avoid perf hit - only go one level deep
      getTransferList(object[key], recursive, transfersSet);
    }
  }

  // If transfers is defined, is internal recursive call
  // Otherwise it's called by the user
  return transfers === undefined ? Array.from(transfersSet) : null;
}

// https://developer.mozilla.org/en-US/docs/Web/API/Transferable
function isTransferable(object) {
  if (!object) {
    return false;
  }
  if (object instanceof ArrayBuffer) {
    return true;
  }
  if (typeof MessagePort !== 'undefined' && object instanceof MessagePort) {
    return true;
  }
  if (typeof ImageBitmap !== 'undefined' && object instanceof ImageBitmap) {
    return true;
  }
  if (typeof OffscreenCanvas !== 'undefined' && object instanceof OffscreenCanvas) {
    return true;
  }
  return false;
}


/***/ }),

/***/ "./src/bundle.js":
/*!***********************!*\
  !*** ./src/bundle.js ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/* global window, global */
const moduleExports = __webpack_require__(/*! ./index */ "./src/index.js");

const _global = typeof window === 'undefined' ? global : window;
// @ts-ignore
_global.loaders = _global.loaders || {};
// @ts-ignore
module.exports = Object.assign(_global.loaders, moduleExports);

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../node_modules/webpack/buildin/global.js */ "../../node_modules/webpack/buildin/global.js")))

/***/ }),

/***/ "./src/index.js":
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
/*! exports provided: TerrainLoader, TerrainWorkerLoader, QuantizedMeshLoader, QuantizedMeshWorkerLoader */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _terrain_loader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./terrain-loader */ "./src/terrain-loader.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TerrainLoader", function() { return _terrain_loader__WEBPACK_IMPORTED_MODULE_0__["TerrainLoader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TerrainWorkerLoader", function() { return _terrain_loader__WEBPACK_IMPORTED_MODULE_0__["TerrainWorkerLoader"]; });

/* harmony import */ var _quantized_mesh_loader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./quantized-mesh-loader */ "./src/quantized-mesh-loader.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuantizedMeshLoader", function() { return _quantized_mesh_loader__WEBPACK_IMPORTED_MODULE_1__["QuantizedMeshLoader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuantizedMeshWorkerLoader", function() { return _quantized_mesh_loader__WEBPACK_IMPORTED_MODULE_1__["QuantizedMeshWorkerLoader"]; });





/***/ }),

/***/ "./src/lib/decode-quantized-mesh.js":
/*!******************************************!*\
  !*** ./src/lib/decode-quantized-mesh.js ***!
  \******************************************/
/*! exports provided: DECODING_STEPS, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DECODING_STEPS", function() { return DECODING_STEPS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return decode; });
// Copyright (C) 2018-2019 HERE Europe B.V.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

const QUANTIZED_MESH_HEADER = new Map([
  ['centerX', Float64Array.BYTES_PER_ELEMENT],
  ['centerY', Float64Array.BYTES_PER_ELEMENT],
  ['centerZ', Float64Array.BYTES_PER_ELEMENT],

  ['minHeight', Float32Array.BYTES_PER_ELEMENT],
  ['maxHeight', Float32Array.BYTES_PER_ELEMENT],

  ['boundingSphereCenterX', Float64Array.BYTES_PER_ELEMENT],
  ['boundingSphereCenterY', Float64Array.BYTES_PER_ELEMENT],
  ['boundingSphereCenterZ', Float64Array.BYTES_PER_ELEMENT],
  ['boundingSphereRadius', Float64Array.BYTES_PER_ELEMENT],

  ['horizonOcclusionPointX', Float64Array.BYTES_PER_ELEMENT],
  ['horizonOcclusionPointY', Float64Array.BYTES_PER_ELEMENT],
  ['horizonOcclusionPointZ', Float64Array.BYTES_PER_ELEMENT]
]);

function decodeZigZag(value) {
  return (value >> 1) ^ -(value & 1);
}

function decodeHeader(dataView) {
  let position = 0;
  const header = {};

  for (const [key, bytesCount] of QUANTIZED_MESH_HEADER) {
    const getter = bytesCount === 8 ? dataView.getFloat64 : dataView.getFloat32;

    header[key] = getter.call(dataView, position, true);
    position += bytesCount;
  }

  return {header, headerEndPosition: position};
}

function decodeVertexData(dataView, headerEndPosition) {
  let position = headerEndPosition;
  const elementsPerVertex = 3;
  const vertexCount = dataView.getUint32(position, true);
  const vertexData = new Uint16Array(vertexCount * elementsPerVertex);

  position += Uint32Array.BYTES_PER_ELEMENT;

  const bytesPerArrayElement = Uint16Array.BYTES_PER_ELEMENT;
  const elementArrayLength = vertexCount * bytesPerArrayElement;
  const uArrayStartPosition = position;
  const vArrayStartPosition = uArrayStartPosition + elementArrayLength;
  const heightArrayStartPosition = vArrayStartPosition + elementArrayLength;

  let u = 0;
  let v = 0;
  let height = 0;

  for (let i = 0; i < vertexCount; i++) {
    u += decodeZigZag(dataView.getUint16(uArrayStartPosition + bytesPerArrayElement * i, true));
    v += decodeZigZag(dataView.getUint16(vArrayStartPosition + bytesPerArrayElement * i, true));
    height += decodeZigZag(
      dataView.getUint16(heightArrayStartPosition + bytesPerArrayElement * i, true)
    );

    vertexData[i] = u;
    vertexData[i + vertexCount] = v;
    vertexData[i + vertexCount * 2] = height;
  }

  position += elementArrayLength * 3;

  return {vertexData, vertexDataEndPosition: position};
}

function decodeIndex(buffer, position, indicesCount, bytesPerIndex, encoded = true) {
  let indices;

  if (bytesPerIndex === 2) {
    indices = new Uint16Array(buffer, position, indicesCount);
  } else {
    indices = new Uint32Array(buffer, position, indicesCount);
  }

  if (!encoded) {
    return indices;
  }

  let highest = 0;

  for (let i = 0; i < indices.length; ++i) {
    const code = indices[i];

    indices[i] = highest - code;

    if (code === 0) {
      ++highest;
    }
  }

  return indices;
}

function decodeTriangleIndices(dataView, vertexData, vertexDataEndPosition) {
  let position = vertexDataEndPosition;
  const elementsPerVertex = 3;
  const vertexCount = vertexData.length / elementsPerVertex;
  const bytesPerIndex =
    vertexCount > 65536 ? Uint32Array.BYTES_PER_ELEMENT : Uint16Array.BYTES_PER_ELEMENT;

  if (position % bytesPerIndex !== 0) {
    position += bytesPerIndex - (position % bytesPerIndex);
  }

  const triangleCount = dataView.getUint32(position, true);
  position += Uint32Array.BYTES_PER_ELEMENT;

  const triangleIndicesCount = triangleCount * 3;
  const triangleIndices = decodeIndex(
    dataView.buffer,
    position,
    triangleIndicesCount,
    bytesPerIndex
  );
  position += triangleIndicesCount * bytesPerIndex;

  return {
    triangleIndicesEndPosition: position,
    triangleIndices
  };
}

function decodeEdgeIndices(dataView, vertexData, triangleIndicesEndPosition) {
  let position = triangleIndicesEndPosition;
  const elementsPerVertex = 3;
  const vertexCount = vertexData.length / elementsPerVertex;
  const bytesPerIndex =
    vertexCount > 65536 ? Uint32Array.BYTES_PER_ELEMENT : Uint16Array.BYTES_PER_ELEMENT;

  const westVertexCount = dataView.getUint32(position, true);
  position += Uint32Array.BYTES_PER_ELEMENT;

  const westIndices = decodeIndex(dataView.buffer, position, westVertexCount, bytesPerIndex, false);
  position += westVertexCount * bytesPerIndex;

  const southVertexCount = dataView.getUint32(position, true);
  position += Uint32Array.BYTES_PER_ELEMENT;

  const southIndices = decodeIndex(
    dataView.buffer,
    position,
    southVertexCount,
    bytesPerIndex,
    false
  );
  position += southVertexCount * bytesPerIndex;

  const eastVertexCount = dataView.getUint32(position, true);
  position += Uint32Array.BYTES_PER_ELEMENT;

  const eastIndices = decodeIndex(dataView.buffer, position, eastVertexCount, bytesPerIndex, false);
  position += eastVertexCount * bytesPerIndex;

  const northVertexCount = dataView.getUint32(position, true);
  position += Uint32Array.BYTES_PER_ELEMENT;

  const northIndices = decodeIndex(
    dataView.buffer,
    position,
    northVertexCount,
    bytesPerIndex,
    false
  );
  position += northVertexCount * bytesPerIndex;

  return {
    edgeIndicesEndPosition: position,
    westIndices,
    southIndices,
    eastIndices,
    northIndices
  };
}

function decodeVertexNormalsExtension(extensionDataView) {
  return new Uint8Array(
    extensionDataView.buffer,
    extensionDataView.byteOffset,
    extensionDataView.byteLength
  );
}

function decodeWaterMaskExtension(extensionDataView) {
  return extensionDataView.buffer.slice(
    extensionDataView.byteOffset,
    extensionDataView.byteOffset + extensionDataView.byteLength
  );
}

function decodeExtensions(dataView, indicesEndPosition) {
  const extensions = {};

  if (dataView.byteLength <= indicesEndPosition) {
    return {extensions, extensionsEndPosition: indicesEndPosition};
  }

  let position = indicesEndPosition;

  while (position < dataView.byteLength) {
    const extensionId = dataView.getUint8(position, true);
    position += Uint8Array.BYTES_PER_ELEMENT;

    const extensionLength = dataView.getUint32(position, true);
    position += Uint32Array.BYTES_PER_ELEMENT;

    const extensionView = new DataView(dataView.buffer, position, extensionLength);

    switch (extensionId) {
      case 1: {
        extensions.vertexNormals = decodeVertexNormalsExtension(extensionView);

        break;
      }
      case 2: {
        extensions.waterMask = decodeWaterMaskExtension(extensionView);

        break;
      }
      default: {
        // console.warn(`Unknown extension with id ${extensionId}`)
      }
    }

    position += extensionLength;
  }

  return {extensions, extensionsEndPosition: position};
}

const DECODING_STEPS = {
  header: 0,
  vertices: 1,
  triangleIndices: 2,
  edgeIndices: 3,
  extensions: 4
};

const DEFAULT_OPTIONS = {
  maxDecodingStep: DECODING_STEPS.extensions
};

function decode(data, userOptions) {
  const options = Object.assign({}, DEFAULT_OPTIONS, userOptions);
  const view = new DataView(data);
  const {header, headerEndPosition} = decodeHeader(view);

  if (options.maxDecodingStep < DECODING_STEPS.vertices) {
    return {header};
  }

  const {vertexData, vertexDataEndPosition} = decodeVertexData(view, headerEndPosition);

  if (options.maxDecodingStep < DECODING_STEPS.triangleIndices) {
    return {header, vertexData};
  }

  const {triangleIndices, triangleIndicesEndPosition} = decodeTriangleIndices(
    view,
    vertexData,
    vertexDataEndPosition
  );

  if (options.maxDecodingStep < DECODING_STEPS.edgeIndices) {
    return {header, vertexData, triangleIndices};
  }

  const {
    westIndices,
    southIndices,
    eastIndices,
    northIndices,
    edgeIndicesEndPosition
  } = decodeEdgeIndices(view, vertexData, triangleIndicesEndPosition);

  if (options.maxDecodingStep < DECODING_STEPS.extensions) {
    return {
      header,
      vertexData,
      triangleIndices,
      westIndices,
      northIndices,
      eastIndices,
      southIndices
    };
  }

  const {extensions} = decodeExtensions(view, edgeIndicesEndPosition);

  return {
    header,
    vertexData,
    triangleIndices,
    westIndices,
    northIndices,
    eastIndices,
    southIndices,
    extensions
  };
}


/***/ }),

/***/ "./src/lib/parse-quantized-mesh.js":
/*!*****************************************!*\
  !*** ./src/lib/parse-quantized-mesh.js ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return loadQuantizedMesh; });
/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @loaders.gl/loader-utils */ "../loader-utils/src/index.js");
/* harmony import */ var _decode_quantized_mesh__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./decode-quantized-mesh */ "./src/lib/decode-quantized-mesh.js");



function getMeshAttributes(vertexData, header, bounds) {
  const {minHeight, maxHeight} = header;
  const [minX, minY, maxX, maxY] = bounds || [0, 0, 1, 1];
  const xScale = maxX - minX;
  const yScale = maxY - minY;
  const zScale = maxHeight - minHeight;

  const nCoords = vertexData.length / 3;
  // vec3. x, y defined by bounds, z in meters
  const positions = new Float32Array(nCoords * 3);

  // vec2. 1 to 1 relationship with position. represents the uv on the texture image. 0,0 to 1,1.
  const texCoords = new Float32Array(nCoords * 2);

  // Data is not interleaved; all u, then all v, then all heights
  for (let i = 0; i < nCoords; i++) {
    const x = vertexData[i] / 32767;
    const y = vertexData[i + nCoords] / 32767;
    const z = vertexData[i + nCoords * 2] / 32767;

    positions[3 * i + 0] = x * xScale + minX;
    positions[3 * i + 1] = y * yScale + minY;
    positions[3 * i + 2] = z * zScale + minHeight;

    texCoords[2 * i + 0] = x;
    texCoords[2 * i + 1] = y;
  }

  return {
    POSITION: {value: positions, size: 3},
    TEXCOORD_0: {value: texCoords, size: 2}
    // TODO: Parse normals if they exist in the file
    // NORMAL: {}, - optional, but creates the high poly look with lighting
  };
}

function getTileMesh(arrayBuffer, options) {
  if (!arrayBuffer) {
    return null;
  }
  const {bounds} = options;
  // Don't parse edge indices or format extensions
  const {header, vertexData, triangleIndices} = Object(_decode_quantized_mesh__WEBPACK_IMPORTED_MODULE_1__["default"])(arrayBuffer, _decode_quantized_mesh__WEBPACK_IMPORTED_MODULE_1__["DECODING_STEPS"].triangleIndices);
  // TODO: use skirt information from file
  const attributes = getMeshAttributes(vertexData, header, bounds);

  return {
    // Data return by this loader implementation
    loaderData: {
      header: {}
    },
    header: {
      vertexCount: triangleIndices.length,
      // TODO: Find bounding box from header, instead of doing extra pass over
      // vertices.
      boundingBox: Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_0__["getMeshBoundingBox"])(attributes)
    },
    mode: 4, // TRIANGLES
    indices: {value: triangleIndices, size: 1},
    attributes
  };
}

function loadQuantizedMesh(arrayBuffer, options) {
  return getTileMesh(arrayBuffer, options['quantized-mesh']);
}


/***/ }),

/***/ "./src/lib/parse-terrain.js":
/*!**********************************!*\
  !*** ./src/lib/parse-terrain.js ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return loadTerrain; });
/* harmony import */ var _mapbox_martini__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mapbox/martini */ "../../node_modules/@mapbox/martini/index.js");
/* harmony import */ var _loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @loaders.gl/loader-utils */ "../loader-utils/src/index.js");



function getTerrain(imageData, tileSize, elevationDecoder) {
  const {rScaler, bScaler, gScaler, offset} = elevationDecoder;

  const gridSize = tileSize + 1;
  // From Martini demo
  // https://observablehq.com/@mourner/martin-real-time-rtin-terrain-mesh
  const terrain = new Float32Array(gridSize * gridSize);
  // decode terrain values
  for (let i = 0, y = 0; y < tileSize; y++) {
    for (let x = 0; x < tileSize; x++, i++) {
      const k = i * 4;
      const r = imageData[k + 0];
      const g = imageData[k + 1];
      const b = imageData[k + 2];
      terrain[i + y] = r * rScaler + g * gScaler + b * bScaler + offset;
    }
  }
  // backfill bottom border
  for (let i = gridSize * (gridSize - 1), x = 0; x < gridSize - 1; x++, i++) {
    terrain[i] = terrain[i - gridSize];
  }
  // backfill right border
  for (let i = gridSize - 1, y = 0; y < gridSize; y++, i += gridSize) {
    terrain[i] = terrain[i - 1];
  }
  return terrain;
}

function getMeshAttributes(vertices, terrain, tileSize, bounds) {
  const gridSize = tileSize + 1;
  const numOfVerticies = vertices.length / 2;
  // vec3. x, y in pixels, z in meters
  const positions = new Float32Array(numOfVerticies * 3);
  // vec2. 1 to 1 relationship with position. represents the uv on the texture image. 0,0 to 1,1.
  const texCoords = new Float32Array(numOfVerticies * 2);

  const [minX, minY, maxX, maxY] = bounds || [0, 0, tileSize, tileSize];
  const xScale = (maxX - minX) / tileSize;
  const yScale = (maxY - minY) / tileSize;

  for (let i = 0; i < numOfVerticies; i++) {
    const x = vertices[i * 2];
    const y = vertices[i * 2 + 1];
    const pixelIdx = y * gridSize + x;

    positions[3 * i + 0] = x * xScale + minX;
    positions[3 * i + 1] = -y * yScale + maxY;
    positions[3 * i + 2] = terrain[pixelIdx];

    texCoords[2 * i + 0] = x / tileSize;
    texCoords[2 * i + 1] = y / tileSize;
  }

  return {
    POSITION: {value: positions, size: 3},
    TEXCOORD_0: {value: texCoords, size: 2}
    // NORMAL: {}, - optional, but creates the high poly look with lighting
  };
}

function getMartiniTileMesh(terrainImage, terrainOptions) {
  if (terrainImage === null) {
    return null;
  }
  const {meshMaxError, bounds, elevationDecoder} = terrainOptions;

  const data = terrainImage.data;
  const tileSize = terrainImage.width;
  const gridSize = tileSize + 1;

  const terrain = getTerrain(data, tileSize, elevationDecoder);

  const martini = new _mapbox_martini__WEBPACK_IMPORTED_MODULE_0__["default"](gridSize);
  const tile = martini.createTile(terrain);
  const {vertices, triangles} = tile.getMesh(meshMaxError);

  const attributes = getMeshAttributes(vertices, terrain, tileSize, bounds);

  return {
    // Data return by this loader implementation
    loaderData: {
      header: {}
    },
    header: {
      vertexCount: triangles.length,
      boundingBox: Object(_loaders_gl_loader_utils__WEBPACK_IMPORTED_MODULE_1__["getMeshBoundingBox"])(attributes)
    },
    mode: 4, // TRIANGLES
    indices: {value: triangles, size: 1},
    attributes
  };
}

async function loadTerrain(arrayBuffer, options, context) {
  options.image = options.image || {};
  options.image.type = 'data';
  const image = await context.parse(arrayBuffer, options, options.baseUri);
  // Extend function to support additional mesh generation options (square grid or delatin)
  return getMartiniTileMesh(image, options.terrain);
}


/***/ }),

/***/ "./src/quantized-mesh-loader.js":
/*!**************************************!*\
  !*** ./src/quantized-mesh-loader.js ***!
  \**************************************/
/*! exports provided: QuantizedMeshWorkerLoader, QuantizedMeshLoader */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuantizedMeshWorkerLoader", function() { return QuantizedMeshWorkerLoader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuantizedMeshLoader", function() { return QuantizedMeshLoader; });
/* harmony import */ var _lib_parse_quantized_mesh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/parse-quantized-mesh */ "./src/lib/parse-quantized-mesh.js");

/** @typedef {import('@loaders.gl/loader-utils').LoaderObject} LoaderObject */

// __VERSION__ is injected by babel-plugin-version-inline
// @ts-ignore TS2304: Cannot find name '__VERSION__'.
const VERSION =  true ? "2.2.7" : undefined;

/** @type {LoaderObject} */
const QuantizedMeshWorkerLoader = {
  id: 'quantized-mesh',
  name: 'Quantized Mesh',
  version: VERSION,
  extensions: ['terrain'],
  mimeTypes: ['application/vnd.quantized-mesh'],
  options: {
    'quantized-mesh': {
      workerUrl: `https://unpkg.com/@loaders.gl/terrain@${VERSION}/dist/quantized-mesh-loader.worker.js`,
      bounds: [0, 0, 1, 1]
    }
  }
};

/** @type {LoaderObject} */
const QuantizedMeshLoader = {
  ...QuantizedMeshWorkerLoader,
  parseSync: _lib_parse_quantized_mesh__WEBPACK_IMPORTED_MODULE_0__["default"],
  parse: async (arrayBuffer, options) => Object(_lib_parse_quantized_mesh__WEBPACK_IMPORTED_MODULE_0__["default"])(arrayBuffer, options)
};


/***/ }),

/***/ "./src/terrain-loader.js":
/*!*******************************!*\
  !*** ./src/terrain-loader.js ***!
  \*******************************/
/*! exports provided: TerrainWorkerLoader, TerrainLoader */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TerrainWorkerLoader", function() { return TerrainWorkerLoader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TerrainLoader", function() { return TerrainLoader; });
/* harmony import */ var _lib_parse_terrain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/parse-terrain */ "./src/lib/parse-terrain.js");
// __VERSION__ is injected by babel-plugin-version-inline



// @ts-ignore TS2304: Cannot find name '__VERSION__'.
const VERSION =  true ? "2.2.7" : undefined;

const TerrainWorkerLoader = {
  id: 'terrain',
  name: 'Terrain',
  version: VERSION,
  extensions: ['png', 'pngraw'],
  mimeTypes: ['image/png'],
  options: {
    terrain: {
      bounds: null,
      workerUrl: `https://unpkg.com/@loaders.gl/terrain@${VERSION}/dist/terrain-loader.worker.js`,
      meshMaxError: 10,
      elevationDecoder: {
        rScaler: 1,
        gScaler: 0,
        bScaler: 0,
        offset: 0
      }
    }
  }
};

const TerrainLoader = {
  ...TerrainWorkerLoader,
  parse: _lib_parse_terrain__WEBPACK_IMPORTED_MODULE_0__["default"]
};


/***/ }),

/***/ 0:
/*!**************************************!*\
  !*** ./require-utils.node (ignored) ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/* (ignored) */

/***/ })

/******/ });
});